#ifndef TRANSKODE_STDINLISTENER_H
#define TRANSKODE_STDINLISTENER_H

/*
*   Copyright (C) 2005 by Ian Monroe <ian@monroe.nu>
*   Released under GPL 2 or later, see COPYING
*/

/*
*   Modified by Sergio Pistone <sergio_pistone@yahoo.com.ar>
*/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <qsocketnotifier.h>

class StdinListener : public QObject
{
	Q_OBJECT
	public:
		StdinListener( QObject* parent=0, const char* name=0 );
		virtual ~StdinListener();

	signals:
		void configureRequested();
		void transcodeRequested( const QStringList& urls, const QString& profile );
		void transferToMediaDeviceRequested( const QString& url, const QString& extension );
		void dataReceived( QString data );
		void communicationClosed();

	public slots:
		void parseInput();

	protected:
		QSocketNotifier* listener;
};

#endif
