#ifndef _TRANSKODE_COMMONDEFS_H_
#define _TRANSKODE_COMMONDEFS_H_

/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <qstring.h>
#include <qstringlist.h>
#include <qmutex.h>

#include <kdebug.h>

namespace GeneralOpt
{
	typedef enum {
		/*base_dir = 0, */naming_scheme = 0,
		notify, confirm, overwrite,
		case_insensitive, replace_chars,
		proc_priority, threads, rt_progress,
		show_tray, log, temp_dir,
		SIZE,
		UNKNOWN
	} TGeneralOpt;

	QString toQString( TGeneralOpt option );
	TGeneralOpt fromQString( const QString& option );
};

namespace ProfileOpt
{
	typedef enum { naming_scheme=0, encode_type, extension, switches, show, bypass, SIZE, UNKNOWN } TProfileOpt;

	QString toQString( TProfileOpt option );
	TProfileOpt fromQString( const QString& option );
};

namespace TextTrans
{
	// Keep in sync with tagsettings.ui!
	typedef enum { leaveasis=0, titlecase, capitalize, lowercase, uppercase, ascii, SIZE, UNKNOWN } TTextTrans;

	QString toQString( TTextTrans transformation );
	TTextTrans fromQString( const QString& transformation );
};

class String
{
	public:
		static QString title( const QString& text );
		static QString capitalize( const QString& text );
		static QString ascii( const QString& text );

		static QString padNumber( const QString& string, unsigned width );

		static bool isValidTextTransformationExpression( const QString& expression );
		static QString evalTextTransformationExpression( const QString& expression );
		static QString evalTextTransformation( const QString& text, const QString& trans );
		static QString evalTextTransformation( const QString& text, TextTrans::TTextTrans trans );

		// Result should be interpreted by shell literally and
		// AS ONE ENCLOSED ARGUMENT WHEN (ONLY WHEN) NOT BEING SURROUNDED BY "
		static QString quoteForShell( const QString& text );

		static QString deepCopy( const QString& string );
		static QStringList deepCopy( const QStringList& stringList );

	protected:
		static int rfindFunctionStart( const QString& text );
		static int rfindFunctionEnd( const QString& text, int startPos );
};

class System
{
	public:
		// FALSE ON ERROR
		static bool copy( const QString& srcPath, const QString& dstPath, bool srcVFAT=false, bool dstVFAT=false );
		static bool move( const QString& srcPath, const QString& dstPath, bool srcVFAT=false, bool dstVFAT=false );
		static bool remove( const QString& path, bool vfat=false );
		static bool recursiveMakeDir( const QString& path, QStringList* createdDirsList=0, bool vfat=false );

		static bool isReadable( const QString& path );
		static bool isWritable( const QString& path );

		static QString user();
		static QString homeDir();
		static QString tempDir();

		// Checks if the given path exists; returns the existing path if it does or else returns ""
		// If vfat is true, path will be searched in a case insensitive way but the returned value
		// will have the actual case of the existing path.
		static QString conflictivePath( const QString& path, bool vfat=false, bool potentialFiles=false, const QString& exception=QString::null );

		// If the path exists, appends a suffix before the extension wich is incremented
		// until the resulting path doesn't exists. If onlyDir is true the resulting
		// path will not conflict with a dir but may conflict with a file.
		static QString nonConflictivePath( const QString& path, bool onlyDir, bool vfat=false, bool potentialFiles=false, const QString& exception=QString::null );

		static void addPotentialFile( const QString& path );
		static void delPotentialFile( const QString& path );
		static void clearPotentialFiles();
		static QString isPotentialFile( const QString& path, bool vfat=false );

	protected:
		static QString correctVFATPath( const QString& path );

		static QStringList s_potentialFiles;
		static QMutex s_potentialFilesMutex;
};

#endif
