/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "logger.h"
#include <commondefs.h>

#include <qthread.h>
#include <qtextstream.h>
#include <qfileinfo.h>
#include <qfile.h>

#include <kglobal.h>

using namespace TransKode;

Logger& Logger::instance()
{
	static Logger obj;
	return obj;
}

Logger::Logger():
	m_path( QString::null ),
	m_file( QString::null ),
	m_prefix( QString::null ),
	m_mutex( false )
{
}

Logger::~Logger()
{
	QMutexLocker locker( &m_mutex );

	if ( ! m_path.isEmpty() )
		m_file.close();
}

QString Logger::file()
{
	QMutexLocker locker( &m_mutex );

	return m_path.isEmpty() ? QString::null : String::deepCopy( m_path );
}

void Logger::setFile( const QString& path, bool truncate, bool force )
{
	QMutexLocker locker( &m_mutex );

	if ( force || path != m_path )
	{
		if ( ! m_path.isEmpty() )
			m_file.close();

		m_path = path;
		m_file.setName( m_path );

		if ( ! m_path.isEmpty() )
		{
			QFileInfo fileInfo( m_path );
			if ( ! fileInfo.exists() || (fileInfo.exists() && fileInfo.isFile()) )
				if ( ! m_file.open( truncate ? IO_WriteOnly|IO_Truncate : IO_WriteOnly|IO_Append ) )
					m_path = QString::null;
		}
	}
}

void Logger::setMsgPrefix( const QString& prefix )
{
	QMutexLocker locker( &m_mutex );

	m_prefix = prefix;
}

void Logger::truncate()
{
	QMutexLocker locker( &m_mutex );

	if ( ! m_path.isEmpty() )
	{
		m_file.close();
		if ( ! m_file.open( IO_WriteOnly|IO_Truncate ) )
			m_path = QString::null;
	}
}

void Logger::log( const QString message )
{
	QMutexLocker locker( &m_mutex );

	kdDebug() << message << endl;

	if ( ! m_path.isEmpty() )
	{
		QTextStream textStream( &m_file );
		textStream << m_prefix << message << "\n";
		m_file.flush();
	}
}

