#ifndef _TRANSKODE_LOGGER_H_
#define _TRANSKODE_LOGGER_H_

/***************************************************************************
 *   Copyright (C) 2006 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <qstring.h>
#include <qfile.h>
#include <qmutex.h>

namespace TransKode
{
	class Logger
	{
		public:

			static Logger& instance();

			QString file();
			void setFile( const QString& file, bool truncate=false, bool force=false );

			void truncate();

			void setMsgPrefix( const QString& prefix );

			void log( const QString message );

		protected:

			Logger();
			Logger( Logger const& );
			Logger& operator=( Logger const& );
			virtual ~Logger();

			QString m_path;
			QFile m_file;
			QString m_prefix;
			mutable QMutex m_mutex;
	};
}

#endif
