/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "metadata.h"

#include <kdebug.h>

using namespace TransKode;

Metadata::Metadata():
	m_values()
{
	for ( int idx = 0; idx < Metadata::SIZE; ++idx )
		m_values[idx] = QString::null;
}

Metadata::Metadata( const Metadata& metadata ):
	m_values()
{
	for ( int idx = 0; idx < Metadata::SIZE; ++idx )
		m_values[idx] = metadata.m_values[idx];
}

Metadata& Metadata::operator=( const Metadata& metadata )
{
	if ( &metadata == this )
		return *this;

	for ( int idx = 0; idx < Metadata::SIZE; ++idx )
		m_values[idx] = metadata.m_values[idx];

	return *this;
};

const QString& Metadata::getValue( Metadata::Tag tag ) const
{
	switch ( tag )
	{
		case Metadata::artist:
		case Metadata::album:
		case Metadata::discnum:
		case Metadata::year:
		case Metadata::track:
		case Metadata::title:
		case Metadata::genre:
		case Metadata::composer:
		case Metadata::comment:
			return m_values[tag];
		default:
			kdWarning() << "invalid metadata value requested: index" << tag;
			return QString::null;
	}
}

void Metadata::setValue( Metadata::Tag tag, int value )
{
	setValue( tag, QString::number( value ) );
}

void Metadata::setValue( Metadata::Tag tag, const QString& value )
{
	switch ( tag )
	{
		case Metadata::artist:
		case Metadata::album:
		case Metadata::discnum:
		case Metadata::year:
		case Metadata::track:
		case Metadata::title:
		case Metadata::genre:
		case Metadata::composer:
		case Metadata::comment:
			m_values[tag] = value;
			break;
		default:
			kdWarning() << "invalid metadata value set: index" << tag;
			break;
	}
}

const QString& Metadata::operator[]( int tag ) const
{
	switch ( tag )
	{
		case Metadata::artist:
		case Metadata::album:
		case Metadata::discnum:
		case Metadata::year:
		case Metadata::track:
		case Metadata::title:
		case Metadata::genre:
		case Metadata::composer:
		case Metadata::comment:
			return m_values[tag];
		default:
			kdWarning() << "invalid metadata value requested: index" << tag;
			return QString::null;
	}
}

QString& Metadata::operator[]( int tag )
{
	switch ( tag )
	{
		case Metadata::artist:
		case Metadata::album:
		case Metadata::discnum:
		case Metadata::year:
		case Metadata::track:
		case Metadata::title:
		case Metadata::genre:
		case Metadata::composer:
		case Metadata::comment:
			return m_values[tag];
		default:
			return m_nullValue;
	}
}

QString Metadata::toQString( Metadata::Tag tag )
{
	switch ( tag )
	{
		case Metadata::artist:		return "artist";
		case Metadata::album:		return "album";
		case Metadata::discnum:		return "discnum";
		case Metadata::year:		return "year";
		case Metadata::track:		return "track";
		case Metadata::title:		return "title";
		case Metadata::genre:		return "genre";
		case Metadata::comment:		return "comment";
		case Metadata::composer:	return "composer";
		default:					return "unknown";
	}
}

Metadata::Tag Metadata::fromQString( const QString& tag )
{
	if 		( tag == "artist" )		return Metadata::artist;
	else if	( tag == "album" )		return Metadata::album;
	else if	( tag == "discnum" )	return Metadata::discnum;
	else if	( tag == "year" )		return Metadata::year;
	else if	( tag == "track" )		return Metadata::track;
	else if	( tag == "title" )		return Metadata::title;
	else if	( tag == "genre" )		return Metadata::genre;
	else if	( tag == "comment" )	return Metadata::comment;
	else if	( tag == "composer" )	return Metadata::composer;
	else							return Metadata::UNKNOWN;
}
