#ifndef TRANSKODE_METADATA_H
#define TRANSKODE_METADATA_H

/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <qstring.h>

namespace TransKode
{
	class Metadata
	{
		public:

			typedef enum {
				artist=0, album, year, discnum, track, title,
				genre, comment, composer, SIZE, UNKNOWN
			} Tag;

			Metadata();
			Metadata( const Metadata& metadata );
			Metadata& operator=( const Metadata& metadata );

			const QString& getValue( Metadata::Tag tag ) const;
			void setValue( Metadata::Tag tag, int value );
			void setValue( Metadata::Tag tag, const QString& value );

			const QString& operator[]( int tag ) const;
			QString& operator[]( int tag );

			static QString toQString( Metadata::Tag tag );
			static Metadata::Tag fromQString( const QString& tag );

		private:

			QString m_values[Metadata::SIZE];
			QString m_nullValue;
	};
}

#endif
