#ifndef TRANSKODE_CONFIGDIALOG_H
#define TRANSKODE_CONFIGDIALOG_H

/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <appconfig.h>
#include <generalsettings.h>
#include <tagsettings.h>
#include <programsettings.h>
#include <profilesettings.h>
#include <streamsettings.h>

#include <kdialogbase.h>
#include <kiconloader.h>

namespace TransKode
{
	class ConfigDialog : public KDialogBase
	{
		Q_OBJECT

		public:
			ConfigDialog( const QString& defaultsPath, bool amarokScript=false, QWidget* parent=0, const char* name=0 );
			virtual ~ConfigDialog();

			void setConfig( const AppConfig& cfg );
			const AppConfig& getConfig() const;

		public slots:
			void saveSelectedProfile();
			void removeSelectedProfile();
			void changeSelectedProfile();

		signals:
			void configSaved();

		protected slots:
			void acceptConfig();
			void acceptConfigAndClose();
			void rejectConfig();
			void rejectConfigAndClose();

			void setControlsFromDefaults();
			void setControlsFromConfig();
			void setConfigFromControls();

			void enableApply();
			void setProfileStatus();

		protected:
			void addPage( QWidget* page, const QString& itemName, const QPixmap& pixmap, const QString& header );
			void addPage( QWidget* page, const QString& itemName, const QString& pixmapName, const QString& header );

		protected:

			KIconLoader m_iconLoader;

			bool amarokScript;

			AppConfig acceptedConfig;
			AppConfig dirtyConfig;
			AppConfig defaultConfig;

			GeneralSettings* generalSettings;
			ProgramSettings* programSettings;
			TagSettings* tagSettings;
			ProfileSettings* profileSettings;

			QString selectedProfile;

			QStringList fixedProfiles;
	};
}

#endif
