#ifndef TRANSKODE_PROFILESETTINGS_UI_H
#define TRANSKODE_PROFILESETTINGS_UI_H

/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <pluginsmanager.h>
#include <informationdialog.h>

#include <kfiledialog.h>
#include <klocale.h>

void ProfileSettings::clickedEncodingSwitchesButton()
{
	const TransKode::EncoderPlugin* plugin = TransKode::PluginsManager::encoderPlugin( encodingTypeComboBox->currentText() );
	if ( plugin == 0 )
		return;

	EncoderDialog* encoderDialog = plugin->newEncoderDialog();
	if ( encoderDialog == 0 )
		return;

	encoderDialog->setSwitches( encodingSwitchesLineEdit->text() );
	encoderDialog->exec();
	if ( encoderDialog->result() == QDialog::Accepted )
		encodingSwitchesLineEdit->setText( encoderDialog->switches() );

	delete encoderDialog;
}


void ProfileSettings::showNamingSchemeInfo()
{
    static const QString namingSchemeInfo( i18n(
	"<p><b><u><font size=\"+1\">Expressions:</font></u></b><br/>"
	"<b>%{artist}</b>: track artist.<br/>"
	"<b>%{album}</b>: track album.<br/>"
	"<b>%{year}</b>: track year.<br/>"
	"<b>%{track#}</b>: track number.<br/>"
	"<b>%{track##}</b>: track number (2 digits).<br/>"
	"<b>%{title}</b>: track title.<br/>"
	"<b>%{genre}</b>: track genre.<br/>"
	"<b>%{comment}</b>: track comment.<br/>"
	"<b>%{dst_ext}</b>: output file extension (depends on the encoding type).<br/>"
	"<b>%{src_ext}</b>: input file extension.<br/>"
	"<b>%{src_name}</b>: input file name (without extension).<br/>"
	"<b>%{src_dir}</b>: input file directory.<br/>"
	"</p>"
	"<p><b><u><font size=\"+1\">Functions:</font></u></b><br/>"
	"<b>capitalize{<text>}</b>: shifts first letter to uppercase and the rest to lowercase.<br/>"
	"<b>titlecase{<text>}</b>: shifts first letter of every word to uppercase and the rest to lowercase.<br/>"
	"<b>lowercase{<text>}</b>: shifts all letters to lowercase.<br/>"
	"<b>uppercase{<text>}</b>: shifts all letters to uppercase.<br/>"
	"<b>ascii{<text>}</b>: replaces each non ascii char with an ascii similar one, or with \"_\" if there's none.<br/>"
	"</p>"
	"<p><b><u><font size=\"+1\">Notes:</font></u></b><br/>"
	"- DO NOT use \"{\" or \"}\" characters for other than the above. If needed, use \"\\{\" or \"\\}\" instead.<br/>"
	"- Values are the ones read by TagLib or defaults when none available (default values and tag cases are defined in Metadata page).<br/>"
	"- Functions override defined tags cases. <br/>"
	"</p>"
	"<p><b><u><font size=\"+1\">Example:</font></u></b><br/>"
	"<b>Artist</b>: mark lanegan / <b>Album</b>: Field songs / <b>Title</b>: reSurrection song / <b>Track</b>: 7 / <b>Ext</b>: OGG<br/>"
	"<b>Scheme</b>: titlecase{%{artist} - %{album}/%{track##} - %{title}}.lowercase{%{dst_ext}}<br/>"
	"<b>Output file</b>: Mark Lanegan - Field Songs/07 - Resurrection Song.ogg<br/>"
	"</p>" ) );

    InformationDialog* infoDialog = new InformationDialog( this );
	infoDialog->setCaption( i18n( "Naming Scheme Info" ) );
	infoDialog->setInfo( namingSchemeInfo );
	infoDialog->show();
}


void ProfileSettings::changeEncodingType( const QString& encodingType )
{
	if( encodingType == "Bypass" )
	{
		bool found = false;
		for ( int idx = 0; idx < encodingTypeComboBox->count(); ++idx )
			if ( encodingTypeComboBox->text( idx ) == "Bypass" )
			{
				encodingTypeComboBox->setCurrentItem( idx );
				found = true;
			}
		if ( ! found )
			return;

		while ( outputExtensionComboBox->count() )
			outputExtensionComboBox->removeItem( 0 );
		outputExtensionComboBox->setEditable( false );
		outputExtensionComboBox->setEnabled( false );

		encodingSwitchesLineEdit->setText( "" );
		encodingSwitchesLineEdit->setEnabled( false );

		encodingSwitchesButton->setEnabled( false );

		return;
	}
	else
	{
		const TransKode::EncoderPlugin* plugin = TransKode::PluginsManager::encoderPlugin( encodingType );
		if ( plugin == 0 )
			return;

		bool found = false;
		for ( int idx = 0; idx < encodingTypeComboBox->count(); ++idx )
			if ( encodingTypeComboBox->text( idx ) == encodingType )
			{
				encodingTypeComboBox->setCurrentItem( idx );
				found = true;
				break;
			}
		if ( ! found )
			return;

		while ( outputExtensionComboBox->count() )
			outputExtensionComboBox->removeItem( 0 );
		QStringList extensions = plugin->extensions();
		for ( QStringList::Iterator it = extensions.begin(); it != extensions.end(); ++it )
			if ( *it != "*" ) outputExtensionComboBox->insertItem( *it );
		if ( outputExtensionComboBox->count() )
			outputExtensionComboBox->setCurrentItem( 0 );

		outputExtensionComboBox->setEditable( extensions.contains( "*" ) );
		outputExtensionComboBox->setEnabled( true );

		if ( ! plugin->configurable() )
		{
			encodingSwitchesLineEdit->setText( "" );
			encodingSwitchesLineEdit->setEnabled( false );
			encodingSwitchesButton->setEnabled( false );
		}
		else
		{
			encodingSwitchesLineEdit->setEnabled( true );
			encodingSwitchesButton->setEnabled( true );
		}
	}
}

#endif
