#ifndef TRANSKODE_PROGRAMSETTINGS_H
#define TRANSKODE_PROGRAMSETTINGS_H

/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include "settingswidget.h"

#include <qgroupbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qmap.h>

#include <kurlrequester.h>
#include <kstandarddirs.h>

class ProgramSettings : public SettingsWidget
{
	Q_OBJECT

	public:
		ProgramSettings( QWidget* parent = 0, const char* name = 0 );
		virtual ~ProgramSettings();

		virtual bool eventFilter( QObject* watched, QEvent* e );

		KURLRequester* programPathURLRequester( const QString& program );
		QPushButton* guessProgramPathButton( const QString& program );

	protected:
		virtual void guessProgramPath( const QString& program );

		QMap<QString,QLabel*> m_programLabels;
		QMap<QString,KURLRequester*> m_programPathURLRequesters;
		QMap<QString,QPushButton*> m_guessProgramPathButtons;
};

class StatusLabel : public QLabel
{
	Q_OBJECT

	public:

		StatusLabel( QWidget* parent, const QPixmap& foundImage, const QPixmap& missingImage ):
			QLabel( parent ),
			m_foundImage( foundImage ),
			m_missingImage( missingImage )
		{
			setPixmap( foundImage );
		}

		virtual ~StatusLabel() {};

	public slots:

		void updateStatus( const QString& programPath )
		{
			setPixmap( KStandardDirs::findExe( programPath ) != QString::null ? m_foundImage : m_missingImage );
		};

	protected:

		QPixmap m_foundImage;
		QPixmap m_missingImage;
};

#endif
