#ifndef TRANSKODE_STREAMSETTINGS_UI_H
#define TRANSKODE_STREAMSETTINGS_UI_H

/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <commondefs.h>

#include <kmessagebox.h>
#include <klocale.h>

void StreamSettings::cleanUpRippedStreams()
{
	if ( KMessageBox::warningContinueCancel(
			this,
			i18n( "<qt><p align=\"center\">Are you sure you want to delete %1 contents?</p></qt>" )
				.arg( "'/tmp/transkode-" + System::user() + "/'" ),
			i18n( "Profile Already Exists" ) ) == KMessageBox::Cancel )
		return;

	QString cmd( "rm -rf /tmp/transkode-" ); cmd += System::user();
	::system( cmd.local8Bit() ); // TODO: remove system call
}

#endif
