#ifndef TRANSKODE_FILEJOB_H
#define TRANSKODE_FILEJOB_H

/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <job.h>

namespace TransKode
{
	class FileJob : public Job
	{
		Q_OBJECT

		public:

			FileJob( const AppConfig& config, const QString& srcPath, const QString& profile=QString::null );
			virtual ~FileJob();

			QString srcPath() const;

		signals:

			/** Warning! this signals MAY NOT be emitted from the main thread (see qt docs on threads): */
			void started( long jobID, const QString& dstPath, const QString& srcPath );
			void finishedOK( long jobID, const QString& dstPath, const QString& srcPath );
			void finishedWithError( long jobID, const QString& errorMsg, const QString& srcPath );

			/** This signals ARE emitted from the main thread: */
			void mtStarted( long jobID, const QString& dstPath, const QString& srcPath );
			void mtFinishedOK( long jobID, const QString& dstPath, const QString& srcPath );
			void mtFinishedWithError( long jobID, const QString& errorMsg, const QString& srcPath );

		protected:

			void readMetadata();

			virtual void evaluateExpressions( QString& dstPath );

			// get the input source (specific to every job type)
			virtual QString fetchSourceFile();
			virtual void removeFetchedSourceFile( const QString& srcPath );

			virtual void normalExit( const QString& dstPath );
			virtual void abnormalExit( const QString& errorMsg );

			virtual void customEvent( QCustomEvent* );

		protected:

			QString m_srcPath;
	};
}

#endif
