#ifndef TRANSKODE_JOBEVENTS_H
#define TRANSKODE_JOBEVENTS_H

/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <commondefs.h>

#include <qevent.h>
#include <qstring.h>
#include <qstringlist.h>

#define EVENT_JOB_DST_PATH_CHANGED			(QEvent::User + 1)
#define EVENT_JOB_STARTED					(QEvent::User + 2)
#define EVENT_JOB_PROGRESS					(QEvent::User + 3)
#define EVENT_JOB_FINISHED_OK				(QEvent::User + 4)
#define EVENT_JOB_FINISHED_WITH_ERROR		(QEvent::User + 5)

#define EVENT_JOB_LAST						(QEvent::User + 5)

class JobDstPathChangedEvent : public QCustomEvent
{
	public:
		JobDstPathChangedEvent( const QString dstPath ):
			QCustomEvent( EVENT_JOB_DST_PATH_CHANGED ),
			m_dstPath( dstPath ) {};

		QString m_dstPath;
};

class JobStartedEvent : public QCustomEvent
{
	public:
		JobStartedEvent( const QString& dstPath ):
			QCustomEvent( EVENT_JOB_STARTED ),
			m_dstPath( dstPath ) {};

		QString m_dstPath;
};

class JobProgressEvent : public QCustomEvent
{
	public:
		JobProgressEvent( int progress ):
			QCustomEvent( EVENT_JOB_PROGRESS ),
			m_progress( progress ) {};

		int m_progress;
};

class JobFinishedOKEvent : public QCustomEvent
{
	public:
		JobFinishedOKEvent( const QString& dstPath ):
			QCustomEvent( EVENT_JOB_FINISHED_OK ),
			m_dstPath( dstPath ) {};

		QString m_dstPath;
};

class JobFinishedWithErrorEvent : public QCustomEvent
{
	public:
		JobFinishedWithErrorEvent( const QString& errorMsg ):
			QCustomEvent( EVENT_JOB_FINISHED_WITH_ERROR ),
			m_errorMsg( errorMsg ) {};

		QString m_errorMsg;
};


#endif
