#ifndef TRANSKODE_FILEJOBQUEUEEVENTS_H
#define TRANSKODE_FILEJOBQUEUEEVENTS_H

/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <qevent.h>
#include <qstring.h>
#include <qstringlist.h>

#define ENQUEUEDEVENT		(QEvent::User + 1)
#define DEQUEUEDEVENT		(QEvent::User + 2)
#define QUEUEEVENT_JOB_STARTED	(QEvent::User + 3)
#define QUEUEDEPLETEDEVENT	(QEvent::User + 4)
#define WORKERSBUSYEVENT	(QEvent::User + 5)
#define WORKERSIDLEEVENT	(QEvent::User + 6)

class EnqueuedEvent : public QCustomEvent
{
	public:
		EnqueuedEvent( long jobID ):
			QCustomEvent( ENQUEUEDEVENT ),
			m_id( jobID ) {};
		long m_id;
};

class DequeuedEvent : public QCustomEvent
{
	public:
		DequeuedEvent( long jobID ):
			QCustomEvent( DEQUEUEDEVENT ),
			m_id( jobID ) {};
		long m_id;
};

class QueueJobStartedEvent : public QCustomEvent
{
	public:
		QueueJobStartedEvent( long jobID ):
			QCustomEvent( QUEUEEVENT_JOB_STARTED ),
			m_id( jobID ) {};
		long m_id;
};

class QueueDepletedEvent : public QCustomEvent
{
	public:
		QueueDepletedEvent( long jobID ):
			QCustomEvent( QUEUEDEPLETEDEVENT ),
			m_id( jobID ) {};
		long m_id;
};

class WorkersBusyEvent : public QCustomEvent
{
	public:
		WorkersBusyEvent():
			QCustomEvent( WORKERSBUSYEVENT ) {}
};

class WorkersIdleEvent : public QCustomEvent
{
	public:
		WorkersIdleEvent( int okCount, int errorCount, int cancelledCount ):
			QCustomEvent( WORKERSIDLEEVENT ),
			m_okCount( okCount ),
			m_errorCount( errorCount ),
			m_cancelledCount( cancelledCount ) {};
		int m_okCount;
		int m_errorCount;
		int m_cancelledCount;
};

#endif
