#ifndef TRANSKODE_WORKER_H
#define TRANSKODE_WORKER_H

/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include "job.h"
#include "jobqueue.h"

#include <processhandler.h>

#include <qthread.h>
#include <qwaitcondition.h>
#include <qmutex.h>

namespace TransKode
{
	class Worker : public QThread
	{
		friend class Job;

		public:

			Worker( JobQueue& jobsQueue );
			virtual ~Worker();

			long id() const;

			void pause();
			void resume();
			void stop();

			bool isPaused() const;
			bool isStopped() const;
			bool isProcessing() const;

		protected:

			virtual void run();

		protected:

			const long m_id;

			JobQueue& m_jobsQueue;

			mutable QMutex m_mutex;

			bool m_stopped;

			bool m_paused;
			QWaitCondition m_pauseCondition;

			Job* m_currentJob;
	};
}

#endif
