#ifndef _ENCODINGTYPEFILETYPERESOLVER_H_
#define _ENCODINGTYPEFILETYPERESOLVER_H_

/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <pluginsmanager.h>
#include <encoderplugin.h>

#include <qmutex.h>

#include <fileref.h>
#include <tag.h>
#include <audioproperties.h>
#include <mpegfile.h>
#include <mpcfile.h>
#include <flacfile.h>
#include <oggfile.h>
#include <oggflacfile.h>
#include <vorbisfile.h>

/**
 * NOTE: only one instance of this class should be added as a file type resolver.
 * That implies that all threads should synchronize access to it.
 */
namespace TransKode
{
	class EncodingTypeFileTypeResolver : public TagLib::FileRef::FileTypeResolver
	{
		public:

			EncodingTypeFileTypeResolver():
				m_encodeType(),
				m_mutex( true ) {}

			void setEncodeType( const QString& encodeType )
			{
				lock();

				m_encodeType = encodeType;

				unlock();
			}

			void lock() const { m_mutex.lock(); }

			void unlock() const { m_mutex.unlock(); }

		protected:

			virtual TagLib::File* createFile(
				const char* fileName,
				bool readAudioProperties = true,
				TagLib::AudioProperties::ReadStyle audioPropertiesStyle = TagLib::AudioProperties::Average ) const
			{
				lock();

				TagLib::File* file = 0;

				const EncoderPlugin* plugin = PluginsManager::encoderPlugin( m_encodeType );
				if ( plugin != 0 )
					file = plugin->newTagLibFile( fileName, readAudioProperties, audioPropertiesStyle );

				if ( file == 0 )
				{
					QFileInfo fileInfo( fileName );
					QString ext = fileInfo.extension().lower();

					if ( ext == "flc" || ext == "flac" )
						file = new TagLib::FLAC::File( fileName, readAudioProperties, audioPropertiesStyle );
					else if ( ext == "ogg" )
						file = new TagLib::Ogg::Vorbis::File( fileName, readAudioProperties, audioPropertiesStyle );
					//else if ( ext == "spx" || ext == "speex" )
					//else if ( ext == "mp4" || ext == "m4a" || ext == "aac" )
					else if ( ext == "ape" || ext == "mac" || ext == "wv" || ext == "mpc" || ext == "mpp" || ext == "mp+" || ext == "ofr" )
						file = new TagLib::MPC::File( fileName, readAudioProperties, audioPropertiesStyle );
					else if ( ext == "mp3" || ext == "tta" )
						file = new TagLib::MPEG::File( fileName, readAudioProperties, audioPropertiesStyle );
				}

				unlock();

				return file;
			}

			QString m_encodeType;
			mutable QMutex m_mutex;
	};
}

#endif
