/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "taglibplugins.h"

#include <taglib/fileref.h>
#include <taglib/tfile.h>

#include <taglib/mpegfile.h>
#include <taglib/oggfile.h>
#include <taglib/oggflacfile.h>
#include <taglib/vorbisfile.h>
#include <taglib/flacfile.h>
#include <taglib/mpcfile.h>

#include "trueaudio/taglib_trueaudiofiletyperesolver.h"
#include "trueaudio/ttafile.h"
#include "wavpack/taglib_wavpackfiletyperesolver.h"
#include "wavpack/wvfile.h"
#include "speex/taglib_speexfiletyperesolver.h"
#include "speex/speexfile.h"
#include "wma/taglib_wmafiletyperesolver.h"
#include "wma/wmafile.h"
#include "rmff/taglib_realmediafiletyperesolver.h"
#include "rmff/taglib_realmediafile.h"
#include "audible/taglib_audiblefiletyperesolver.h"
#include "audible/taglib_audiblefile.h"
#include "aac/aacfiletyperesolver.h"
#include "taglib_mimetypefiletyperesolver.h"
#include "taglib_encodingtypefiletyperesolver.h"

TransKode::EncodingTypeFileTypeResolver* TransKode::TagLibPlugins::s_encodingTypeFileTypeResolver( 0 );

void TransKode::TagLibPlugins::registerFileTypeResolvers()
{
// 	TagLib::FileRef::addFileTypeResolver( new MimeTypeFileTypeResolver );
// 	TagLib::FileRef::addFileTypeResolver( new WMAFileTypeResolver ); // crashes with ffmpeg generated files
	TagLib::FileRef::addFileTypeResolver( new RealMediaFileTypeResolver );
	TagLib::FileRef::addFileTypeResolver( new AudibleFileTypeResolver );
	TagLib::FileRef::addFileTypeResolver( new AACFileTypeResolver );
	TagLib::FileRef::addFileTypeResolver( new WavPackFileTypeResolver );
	TagLib::FileRef::addFileTypeResolver( new SpeexFileTypeResolver );
	TagLib::FileRef::addFileTypeResolver( new TTAFileTypeResolver );
	TagLib::FileRef::addFileTypeResolver( s_encodingTypeFileTypeResolver = new TransKode::EncodingTypeFileTypeResolver );
}

TransKode::EncodingTypeFileTypeResolver* TransKode::TagLibPlugins::encodingTypeFileTypeResolver()
{
	return s_encodingTypeFileTypeResolver;
}
