/***************************************************************************
 *   Copyright (C) 2006 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "bonkencoderdialog.h"

#include <qregexp.h>
#include <qcheckbox.h>
#include <kcombobox.h>
#include <kdecspinbox.h>

BonkEncoderDialog::BonkEncoderDialog( QWidget* parent, const char* name ):
	BonkEncoderDialogBase( parent, name ) {}

BonkEncoderDialog::~BonkEncoderDialog() {}

void BonkEncoderDialog::setSwitches( const QString& switches )
{
	QRegExp regExp;
 	regExp.setCaseSensitive( false );

	regExp.setPattern( "(^|[ \\t])-l([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		losslessModeCheckBox->setChecked( true );
		quantizationLevelCheckBox->setEnabled( false );
		downsamplingRatioCheckBox->setEnabled( false );
		predictorSizeCheckBox->setEnabled( false );
		stereoModeCheckBox->setEnabled( false );
	}
	else
	{
		regExp.setPattern( "(^|[ \\t])-q[ \\t]*([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
		{
			quantizationLevelCheckBox->setChecked( true );
			quantizationLevelDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
		}

		regExp.setPattern( "(^|[ \\t])-d[ \\t]*([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
		{
			downsamplingRatioCheckBox->setChecked( true );
			downsamplingRatioSpinBox->setValue( (int)regExp.cap( 2 ).toDouble() );
		}

		regExp.setPattern( "(^|[ \\t])-s[ \\t]*([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
		{
			predictorSizeCheckBox->setChecked( true );
			predictorSizeSpinBox->setValue( (int)regExp.cap( 2 ).toFloat() );
		}

		regExp.setPattern( "(^|[ \\t])-m[ \\t](on|off)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
		{
			stereoModeCheckBox->setChecked( true );
			stereoModeComboBox->setCurrentItem( regExp.cap( 2 ).lower() == "on" ? 0 : 1 );
		}
	}
}

QString BonkEncoderDialog::switches()
{
	QString result;

	if ( losslessModeCheckBox->isChecked() )
		return "-l";
	else
	{
		if ( quantizationLevelCheckBox->isChecked() )
			result += " -q " + QString::number( quantizationLevelDecSpinBox->decimalValue() );
		if ( downsamplingRatioCheckBox->isChecked() )
			result += " -d " + QString::number( downsamplingRatioSpinBox->value() );
		if ( predictorSizeCheckBox->isChecked() )
			result += " -s " + QString::number( predictorSizeSpinBox->value() );
		if ( stereoModeCheckBox->isChecked() )
		{
			if ( stereoModeComboBox->currentItem() == 0 )
				result += " -m on ";
			else // if ( stereoModeComboBox->currentItem() == 1 )
				result += " -m off";
		}
		return result.simplifyWhiteSpace();
	}
}
