#ifndef TRANSKODE_CPENCODERPLUGIN_H
#define TRANSKODE_CPENCODERPLUGIN_H

/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <encoderplugin.h>

namespace TransKode
{
	class CPEncoderPlugin : public EncoderPlugin
	{
		friend class PluginsManager;

		public:

			virtual bool configurable() const
			{
				return false;
			}

			virtual void setupArgs( ProcessHandler& proc, const QString& src, const QString& dst, const QString&, const Metadata& ) const
			{
				proc.clearArguments();
				bool pMode = proc.getShellParsingMode();
				proc.setShellParsingMode( false );
				proc << programPath() << src << dst;
				proc.setShellParsingMode( pMode );
			}

			virtual ProgressParser* newProgressParser() const
			{
				return 0;
			}

			virtual TagLib::File* newTagLibFile( const char*, bool, int ) const
			{
				return 0;
			}

		protected:

			virtual EncoderDialog* _newEncoderDialog( QWidget*, const char* ) const
			{
				return 0;
			}

			CPEncoderPlugin():EncoderPlugin( "Dummy", QString::null, "cp", QStringList::split( ":", "wav:*" ) ) {}

			~CPEncoderPlugin() {}
	};
}

#endif

