#ifndef TRANSKODE_DECODERPLUGIN_H
#define TRANSKODE_DECODERPLUGIN_H

/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include "plugin.h"
#include <qstringlist.h>

namespace TransKode
{
	class DecoderPlugin : public Plugin
	{
		public:
			DecoderPlugin( const QString& name=QString::null, const QString& desc=QString::null, const QString& dfltExec=QString::null, QStringList extensions=QStringList() ):
				Plugin( name, desc, dfltExec, extensions ) {}
			~DecoderPlugin() {}

			virtual void setupArgs( ProcessHandler& proc, const QString& src, const QString& dst ) const = 0;

			bool canDecodeExtension( const QString& extension ) const
			{
				if ( ! isLocallySupported() )
					return false;

				QString ext = extension.lower();

				if ( m_extensions.find( QString( "-" ) + ext ) != m_extensions.end() )
					return false;
				else if ( m_extensions.find( ext ) != m_extensions.end() || m_extensions.find( "*" ) != m_extensions.end() )
					return true;
				else
					return false;
			}
	};
}

#endif
