/***************************************************************************
*   Copyright (C) 2005 by Sergio Pistone                                  *
*   sergio_pistone@yahoo.com.ar                                           *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

#include "encoderhelpdialog.h"

#include "processhandler.h"
#include "processoutput.h"

#include <qregexp.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <ktextedit.h>
#include <klocale.h>

EncoderHelpDialog::EncoderHelpDialog( QString plugin, QString program, QString programPath, QString helpSwitch, QWidget* parent, const char* name, WFlags f ):
	EncoderDialog( parent, name, f ),
	m_switches()
{
	setCaption( i18n( "%1 Help" ).arg( plugin ) );

	QGridLayout* gridLayout = new QGridLayout( this, 1, 1, 11, 6, "gridLayout" );

	KTextEdit* infoTextEdit = new KTextEdit( this, "infoTextEdit" );
	gridLayout->addWidget( infoTextEdit, 0, 0 );

	infoTextEdit->setFrameShape( KTextEdit::LineEditPanel );
	infoTextEdit->setResizePolicy( KTextEdit::Manual );
	infoTextEdit->setWordWrap( KTextEdit::WidgetWidth );
	infoTextEdit->setReadOnly( true );
	infoTextEdit->setAutoFormatting( QTextEdit::AutoNone );
	infoTextEdit->setTextFormat( Qt::PlainText );
	QString text = getProgramInformation( program, programPath, helpSwitch );
	infoTextEdit->setText( text.isEmpty() ? i18n( "Sorry... no information found" ) : text );
 	QFont font( infoTextEdit->font() );
	font.setFamily( "monospace" );
    infoTextEdit->setFont( font );


	QHBoxLayout* hboxLayout = new QHBoxLayout( 0, 0, 6, "hboxLayout" );
	gridLayout->addLayout( hboxLayout, 1, 0 );

	QSpacerItem* spacer = new QSpacerItem( 300, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
	hboxLayout->addItem( spacer );

	QPushButton* okButton = new QPushButton( this, "okButton" );
	hboxLayout->addWidget( okButton );
	okButton->setDefault( true );
	okButton->setText( i18n( "&OK" ) );

	resize( QSize( 600, 500 ).expandedTo( minimumSizeHint() ) );

	connect( okButton, SIGNAL( clicked() ), this, SLOT( close() ) );
}

EncoderHelpDialog::~EncoderHelpDialog()
{
}

QString EncoderHelpDialog::cleanupConsoleText( QString text )
{
	text.replace( QRegExp( "(.)\\1" ), "\\1" );
	text.replace( QRegExp( "_(.)" ), "\\1" );
	text.replace( QRegExp( "+o" ), "*" );
	return text;
}

QString EncoderHelpDialog::getProgramManInformation( QString program )
{
	QString information;

	ProcessHandler process( 0, QProcess::Stdout );
	process << "man" << "1" << program;
	OutputGrabber* outputGrabber = new OutputGrabber( &process );
	if ( process.start() )
	{
		process.waitProcess( 1000 );
		if ( process.exitStatus() == 0 )
			information = cleanupConsoleText( outputGrabber->getOutputAsString() );
		process.kill();
	}
	delete outputGrabber;

	return information;
}

QString EncoderHelpDialog::getProgramHelpInformation( QString programPath, QString helpSwitch )
{
	QString information;

	ProcessHandler process( 0, QProcess::Stdout|QProcess::Stderr|QProcess::DupStderr );
	process << programPath << helpSwitch;
	OutputGrabber* outputGrabber = new OutputGrabber( &process );
	if ( process.start() )
	{
		process.waitProcess( 1000 );
		process.kill();
		information = cleanupConsoleText( outputGrabber->getOutputAsString() );
	}

	delete outputGrabber;

	return information;
}

QString EncoderHelpDialog::getProgramInformation( QString program, QString programPath, QString helpSwitch )
{
	QString information = getProgramManInformation( program );
	if ( information.isEmpty() && ! helpSwitch.isEmpty() )
		information = getProgramHelpInformation( programPath.isEmpty() ? program : programPath, helpSwitch );
	return information;
}

void EncoderHelpDialog::setSwitches( const QString& switches )
{
	m_switches = switches;
}

QString EncoderHelpDialog::switches()
{
	return m_switches;
}
