#ifndef TRANSKODE_ENCODERHELPDIALOG_H
#define TRANSKODE_ENCODERHELPDIALOG_H

/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <encoderdialog.h>

class EncoderHelpDialog : public EncoderDialog
{
	Q_OBJECT

	public:
		EncoderHelpDialog( QString plugin, QString program, QString programPath, QString helpSwitch=QString::null, QWidget* parent=0, const char* name=0, WFlags f=0 );
		virtual ~EncoderHelpDialog();

		virtual void setSwitches( const QString& switches );
		virtual QString switches();

		static QString getProgramManInformation( QString programPath );
		static QString getProgramHelpInformation( QString program, QString helpSwitch );

		static QString getProgramInformation( QString program, QString programPath=QString::null, QString helpSwitch=QString::null );

	protected:

		static QString cleanupConsoleText( QString text );

		QString m_switches;
};

#endif
