#ifndef TRANSKODE_ENCODERPLUGIN_H
#define TRANSKODE_ENCODERPLUGIN_H

/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include "plugin.h"
#include <encoderdialog.h>

#include <commondefs.h>
#include <metadata.h>

#include <qstringlist.h>

namespace TagLib { class File; }

namespace TransKode
{
	class EncoderPlugin : public Plugin
	{
		public:
			EncoderPlugin( const QString& name=QString::null, const QString& desc=QString::null, const QString& dfltExec=QString::null, QStringList extensions=QStringList() ):
				Plugin( name, desc, dfltExec, extensions ) {}
			~EncoderPlugin() {}

			virtual bool configurable() const = 0;

			virtual void setupArgs( ProcessHandler& proc, const QString& src, const QString& dst, const QString& switches, const Metadata& tags ) const = 0;

			EncoderDialog* newEncoderDialog( QWidget* parent=0, const char* name=0 ) const
			{
				return configurable() ? _newEncoderDialog( parent, name ) : 0;
			}

			virtual TagLib::File* newTagLibFile( const char* fileName, bool readAudioProp, int audioPropStyle ) const = 0;

		protected:
			virtual EncoderDialog* _newEncoderDialog( QWidget* parent=0, const char* name=0 ) const = 0;
	};
}

#endif


