/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "faacencoderdialog.h"

#include <qregexp.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qslider.h>
#include <kcombobox.h>
#include <knuminput.h>

FAACEncoderDialog::FAACEncoderDialog( QWidget* parent, const char* name ):
	FAACEncoderDialogBase( parent, name ) {}

FAACEncoderDialog::~FAACEncoderDialog() {}

void FAACEncoderDialog::setSwitches( const QString& switches )
{
	QRegExp regExp;

	regExp.setPattern( "(^|[ \\t])-q[ \\t]+([0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1  )
	{
		vbrRadioButton->setChecked( true );
		vbrSlider->setValue( regExp.cap( 2 ).toInt() );
	}
	else
	{
		regExp.setPattern( "(^|[ \\t])-b[ \\t]+([0-9]+)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1  )
		{
			abrRadioButton->setChecked( true );
			abrSlider->setValue( regExp.cap( 2 ).toInt() );
		}
	}

	regExp.setPattern( "(^|[ \\t])-c[ \\t]+([0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1  )
	{
		bandwidthCheckBox->setChecked( true );
		bandwidthSpinBox->setValue( regExp.cap( 2 ).toInt() );
	}

	regExp.setPattern( "(^|[ \\t])-r([ \\t]|$)" );
	if ( regExp.search( switches ) != -1  )
		rawAACCheckBox->setChecked( true );

	regExp.setPattern( "(^|[ \\t])-w([ \\t]|$)" );
	if ( regExp.search( switches ) != -1  )
		wrapAACDataCheckBox->setChecked( true );

	regExp.setPattern( "(^|[ \\t])--no-tns([ \\t]|$)" );
	if ( regExp.search( switches ) != -1  )
		disableTNSCheckBox->setChecked( true );

	regExp.setPattern( "(^|[ \\t])--no-midside([ \\t]|$)" );
	if ( regExp.search( switches ) != -1  )
		disableMSCodingCheckBox->setChecked( true );

	regExp.setPattern( "(^|[ \\t])--mpeg-vers[ \\t]+(2|4)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1  )
	{
		mpegVersionCheckBox->setChecked( true );
		mpegVersionComboBox->setCurrentItem( regExp.cap( 2 ) == "2" ? 0 : 1 );
	}

	regExp.setPattern( "(^|[ \\t])--obj-type[ \\t]+(lc|main|ltp)([ \\t]|$)" );
	if ( regExp.search( switches.lower() ) != -1  )
	{
		objectTypeCheckBox->setChecked( true );

		if ( regExp.cap( 2 ) == "lc" )
			objectTypeComboBox->setCurrentItem( 0 );
		else if ( regExp.cap( 2 ) == "main" )
			objectTypeComboBox->setCurrentItem( 1 );
		else
			objectTypeComboBox->setCurrentItem( 2 );
	}

	regExp.setPattern( "(^|[ \\t])--shortctl[ \\t]+(1|2)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1  )
	{
		blockTypeCheckBox->setChecked( true );
		blockTypeComboBox->setCurrentItem( regExp.cap( 2 ).toInt()-1 );
	}
}

QString FAACEncoderDialog::switches()
{
	QString result;

	if ( vbrRadioButton->isChecked()  )
		result = "-q " + QString::number( vbrSlider->value() );
	else
		result = "-b " + QString::number( abrSlider->value() );

	if ( bandwidthCheckBox->isChecked() )
		result += " -c " + bandwidthSpinBox->cleanText();

	if ( rawAACCheckBox->isChecked() )
		result += " -r";

	if ( wrapAACDataCheckBox->isChecked() )
		result += " -w";

	if ( disableTNSCheckBox->isChecked() )
		result += " --no-tns";

	if ( disableMSCodingCheckBox->isChecked() )
		result += " --no-midside";

	if ( mpegVersionCheckBox->isChecked() )
		result += mpegVersionComboBox->currentItem() == 0 ? " --mpeg-vers 2" : " --mpeg-vers 4";

	if ( objectTypeCheckBox->isChecked() )
	{
		if ( objectTypeComboBox->currentItem() == 0 )
			result += " --obj-type LC";
		else if ( objectTypeComboBox->currentItem() == 1 )
			result += " --obj-type Main";
		else
			result += " --obj-type LTP";
	}

	if ( blockTypeCheckBox->isChecked() )
		result += blockTypeComboBox->currentItem() == 0 ? " --shortctl 1" : " --shortctl 2";

	return result;
}
