#ifndef TRANSKODE_FAACENCODERPLUGIN_H
#define TRANSKODE_FAACENCODERPLUGIN_H

/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <encoderplugin.h>
#include <processoutput.h>
#include "faacencoderdialog.h"

namespace TransKode
{
	class FAACEncoderPlugin : public EncoderPlugin
	{
		friend class PluginsManager;

		public:

			virtual bool configurable() const
			{
				return true;
			}

			virtual void setupArgs( ProcessHandler& proc, const QString& src, const QString& dst, const QString& switches, const Metadata& tags ) const
			{
				proc.clearArguments();
				bool pMode = proc.getShellParsingMode();
				proc.setShellParsingMode( false );
				proc << programPath();
				proc.setShellParsingMode( true );
				proc << switches;
				proc.setShellParsingMode( false );

				if ( isMetadataSupported() )
				{
					if ( ! tags[Metadata::artist].isEmpty() )		{ proc << "--artist" << tags[Metadata::artist]; }
					if ( ! tags[Metadata::year].isEmpty() )			{ proc << "--year" << tags[Metadata::year]; }
					if ( ! tags[Metadata::album].isEmpty() )		{ proc << "--album" << tags[Metadata::album]; }
					if ( ! tags[Metadata::track].isEmpty() )		{ proc << "--track" << tags[Metadata::track]; }
					if ( ! tags[Metadata::title].isEmpty() )		{ proc << "--title" << tags[Metadata::title]; }
					if ( ! tags[Metadata::comment].isEmpty() )		{ proc << "--comment" << tags[Metadata::comment]; }
					if ( ! tags[Metadata::genre].isEmpty() )		{ proc << "--genre" << tags[Metadata::genre]; }
				}

				proc << "-o" << dst << src;
				proc.setShellParsingMode( pMode );
			}

			virtual ProgressParser* newProgressParser() const
			{
				return new RegExpProgressParser( ".*\\( *(\\d+)%\\)", RegExpProgressParser::int_percentage );
			}

			virtual TagLib::File* newTagLibFile( const char*, bool, int ) const
			{
				return 0;
			}

		protected:

			virtual void setProgramPath( const QString& path )
			{
				EncoderPlugin::setProgramPath( path );

				if ( path != programPath() )
				{
					QMutexLocker locker( &m_mutex );

					m_mdCheck = true; // force metadata support check
				}
			}

			virtual EncoderDialog* _newEncoderDialog( QWidget* parent=0, const char* name=0 ) const
			{
				return new FAACEncoderDialog( parent, name );
			}

			FAACEncoderPlugin():
				EncoderPlugin( "FAAC", QString::null, "faac", QStringList::split( ":", "aac:mp4:m4a:m4b:*" ) ),
				m_mdCheck( true ),
				m_mdSupported( true )
			{
			}

			~FAACEncoderPlugin() {}

			bool isMetadataSupported() const
			{
				QMutexLocker locker( &m_mutex );

				if ( ! m_mdCheck )
					return m_mdSupported;

				m_mdCheck = false;

				//ProcessHandler process( 0, QProcess::Stdout|QProcess::Stderr|QProcess::DupStderr );
				ProcessHandler process( 0, QProcess::Stderr );
				process <<  programPath() << "--help";

				OutputGrabber* outputGrabber = new OutputGrabber( &process );

				if ( process.start() )
				{
					// NOTE: this inevitably timeouts if the event loop is not running
					process.waitProcess( 2000 );
					m_mdSupported = outputGrabber->getOutputAsString().contains( "--artist X" );
				}
				else
					m_mdSupported = false;

				kdDebug() << "FAAC metadata support " << (m_mdSupported ? "found" : "not found") << endl;

				delete outputGrabber;

				return m_mdSupported;
			}

			mutable bool m_mdCheck;
			mutable bool m_mdSupported;
	};
}

#endif

