#ifndef TRANSKODE_FLACENCODERDIALOGBASE_UI_H
#define TRANSKODE_FLACENCODERDIALOGBASE_UI_H

/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <kdecspinbox.h>

#include <kfiledialog.h>
#include <klocale.h>

void FLACEncoderDialogBase::selectCueSheet()
{
	QString path = KFileDialog::getOpenFileName(
		cueSheetLineEdit->text(),									// start path
		"*.cue", this,													// filter, parent
		i18n( "Find the path to the cuesheet file" ) );		// caption

	if ( path != QString::null )
		cueSheetLineEdit->setText( path );
}


void FLACEncoderDialogBase::setCheckedSectorAlign( bool checked )
{
	if ( checked )
	{
		startButtonGroup->setChecked( false );
		durationButtonGroup->setChecked( false );

		setCheckedStart( false );
		setCheckedDuration( false );
	}

	startButtonGroup->setEnabled( ! checked );
	durationButtonGroup->setEnabled( ! checked );

}


void FLACEncoderDialogBase::setCheckedStart( bool checked )
{
	startTimeRadioButton->setEnabled( checked );
	startSamplesRadioButton->setEnabled( checked );

	bool enableSubControls = startTimeRadioButton->isChecked() && checked;
	startMinsSpinBox->setEnabled( enableSubControls );
	startSecsSpinBox->setEnabled( enableSubControls );
	startMsecsSpinBox->setEnabled( enableSubControls );

	startSamplesSpinBox->setEnabled( startSamplesRadioButton->isChecked() && checked );
}


void FLACEncoderDialogBase::setCheckedDuration( bool checked )
{
	durationTimeRadioButton->setEnabled( checked );
	durationSamplesRadioButton->setEnabled( checked );
	relativeToEndCheckBox->setEnabled( checked );

	bool enableSubControls = durationTimeRadioButton->isChecked() && checked;
	durationMinsSpinBox->setEnabled( enableSubControls );
	durationSecsSpinBox->setEnabled( enableSubControls );
	durationMsecsSpinBox->setEnabled( enableSubControls );

	durationSamplesSpinBox->setEnabled( durationSamplesRadioButton->isChecked() && checked );
}


void FLACEncoderDialogBase::setCheckedSeekPoints( bool checked )
{
	seekPointsSecsRadioButton->setEnabled( checked );
	seekPointsCountRadioButton->setEnabled( checked );

	seekPointsSecsDecSpinBox->setEnabled( seekPointsSecsRadioButton->isChecked() && checked );

	seekPointsCountSpinBox->setEnabled( seekPointsCountRadioButton->isChecked() && checked );
}


void FLACEncoderDialogBase::setCheckedMaxResidualPO( bool checked )
{
	minResidualPOCheckBox->setEnabled( checked );
	if ( ! checked )
		minResidualPOCheckBox->setChecked( false );
}


void FLACEncoderDialogBase::setCheckedBlockSize( bool checked )
{
	strictBlockSizeRadioButton->setEnabled( checked );
	laxBlockSizeRadioButton->setEnabled( checked );

	bool enabled = strictBlockSizeRadioButton->isChecked() && checked;
	strictBlockSizeComboBox->setEnabled( enabled );
	strictBlockSizeLabel->setEnabled( enabled );

	enabled = laxBlockSizeRadioButton->isChecked() && checked;
	laxBlockSizeSpinBox->setEnabled( enabled );
	laxBlockSizeLabel->setEnabled( enabled );
}

#endif
