/***************************************************************************
 *   Copyright (C) 2006 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include "laencoderdialog.h"

#include <qregexp.h>
#include <qcheckbox.h>

LAEncoderDialog::LAEncoderDialog( QWidget* parent, const char* name ):
	LAEncoderDialogBase( parent, name ) {}

LAEncoderDialog::~LAEncoderDialog() {}

void LAEncoderDialog::setSwitches( const QString& switches )
{
	QRegExp regExp;

	regExp.setPattern( "(^|[ \\t])-high([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		highCompressionModeCheckBox->setChecked( true );

	regExp.setPattern( "(^|[ \\t])-noseek([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		disableSeekPointsCheckBox->setChecked( true );
}

QString LAEncoderDialog::switches()
{
	QString result;

	if ( highCompressionModeCheckBox->isChecked() )
		result += "-high";
	if ( disableSeekPointsCheckBox->isChecked() )
		result += " -noseek";

	return result.simplifyWhiteSpace();
}
