#ifndef TRANSKODE_LAPROGRESSPARSER_H
#define TRANSKODE_LAPROGRESSPARSER_H

/***************************************************************************
 *   Copyright (C) 2006 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include "progressparser.h"
#include <qregexp.h>

namespace TransKode
{
	class LAProgressParser : public ProgressParser
	{
		public:

			LAProgressParser():
				m_regExp( ".* \\[(\\**)(\\.+)\\]" ) {}
			virtual ~LAProgressParser() {}

		protected:

			int parseProgress( const QString& line )
			{
				if ( m_regExp.search( line ) != -1 )
				{
					int done = m_regExp.cap( 1 ).length();
					int remaining = m_regExp.cap( 2 ).length();
					//return (int)((100.0*done)/(done+remaining));
					return (100*done)/(done+remaining);
				}
				else
					return -1;
			}

			QRegExp m_regExp;
	};
}

#endif
