/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "lameencoderdialog.h"

#include <qregexp.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <kcombobox.h>
#include <kdecspinbox.h>

LAMEEncoderDialog::LAMEEncoderDialog( QWidget* parent, const char* name ):
	LAMEEncoderDialogBase( parent, name ) {}

LAMEEncoderDialog::~LAMEEncoderDialog() {}

void LAMEEncoderDialog::setSwitches( const QString& switches )
{
	/**
	* BITRATE SETTINGS
	*/

	QRegExp regExp( "(^|[ \\t])--freeformat([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		freeFormatRadioButton->setChecked( true );
		regExp.setPattern( "(^|[ \\t])-b[ \\t]+([0-9]+)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1  )
			freeFormatSpinBox->setValue( regExp.cap( 2 ).toInt() );
	}
	else
	{
		regExp.setPattern( "(^|[ \\t])-b[ \\t]+(32|40|48|56|64|80|96|112|128|160|192|224|256|320)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
		{
			minBitrateCheckBox->setChecked( true );
			int bitrateIdx = 0;
			int bitrate = regExp.cap( 2 ).toInt();
			switch ( bitrate )
			{
				case 32:	bitrateIdx = 0;		break;
				case 40:	bitrateIdx = 1;		break;
				case 48:	bitrateIdx = 2;		break;
				case 56:	bitrateIdx = 3;		break;
				case 64:	bitrateIdx = 4;		break;
				case 80:	bitrateIdx = 5;		break;
				case 96:	bitrateIdx = 6;		break;
				case 112:	bitrateIdx = 7;		break;
				case 128:	bitrateIdx = 8;		break;
				case 160:	bitrateIdx = 9;		break;
				case 192:	bitrateIdx = 10;	break;
				case 224:	bitrateIdx = 11;	break;
				case 256:	bitrateIdx = 12;	break;
				case 320:	bitrateIdx = 13;	break;
			}
			minBitrateComboBox->setCurrentItem( bitrateIdx );
		}

		bool allowMaxBitrate = false;

		regExp.setPattern( "(^|[ \\t])--abr[ \\t]+([0-9]+)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
		{
			allowMaxBitrate = true;

			avgBitrateSpinBox->setValue( regExp.cap( 2 ).toInt() );
			bitrateModeComboBox->setCurrentItem( 1 ); // ABR mode
			changeItemBitrateMode();

			regExp.setPattern( "(^|[ \\t])-F([ \\t]|$)" );
			if ( regExp.search( switches ) != -1 )
				enforceMinBitrateCheckBox->setChecked( true );
		}
		else
		{
			regExp.setPattern( "(^|[ \\t])(v|--vbr-old|--vbr-new)([ \\t]|$)" );
			if ( regExp.search( switches ) == -1 )
				regExp.setPattern( "(^|[ \\t])-V[ \\t]+[0-9]([ \\t]|$)" );
			if ( regExp.search( switches ) != -1 )
			{
				allowMaxBitrate = true;

				if ( regExp.cap( 2 ) == "--vbr-new" )
					bitrateModeComboBox->setCurrentItem( 3 ); //VBR NEW
				else
					bitrateModeComboBox->setCurrentItem( 2 ); //VBR OLD
				changeItemBitrateMode();

				regExp.setPattern( "(^|[ \\t])-V[ \\t]+([0-9])([ \\t]|$)" );
				if ( regExp.search( switches ) != -1 )
				{
					vbrQualityCheckBox->setChecked( true );
					vbrQualityComboBox->setCurrentItem( regExp.cap( 2 ).toInt() );
				}

				regExp.setPattern( "(^|[ \\t])-F([ \\t]|$)" );
				if ( regExp.search( switches ) != -1 )
					enforceMinBitrateCheckBox->setChecked( true );
			}
		}

		if ( allowMaxBitrate )
		{
			regExp.setPattern( "(^|[ \\t])-B[ \\t]+(32|40|48|56|64|80|96|112|128|160|192|224|256|320)([ \\t]|$)" );
			if ( regExp.search( switches ) != -1 )
			{
				maxBitrateCheckBox->setChecked( true );
				int bitrateIdx = 0;
				int bitrate = regExp.cap( 2 ).toInt();
				switch ( bitrate )
				{
					case 32:	bitrateIdx = 0;		break;
					case 40:	bitrateIdx = 1;		break;
					case 48:	bitrateIdx = 2;		break;
					case 56:	bitrateIdx = 3;		break;
					case 64:	bitrateIdx = 4;		break;
					case 80:	bitrateIdx = 5;		break;
					case 96:	bitrateIdx = 6;		break;
					case 112:	bitrateIdx = 7;		break;
					case 128:	bitrateIdx = 8;		break;
					case 160:	bitrateIdx = 9;		break;
					case 192:	bitrateIdx = 10;	break;
					case 224:	bitrateIdx = 11;	break;
					case 256:	bitrateIdx = 12;	break;
					case 320:	bitrateIdx = 13;	break;
				}
				maxBitrateComboBox->setCurrentItem( bitrateIdx );
			}
		}
	}


	/**
	* METADATA SETTINGS
	*/

	regExp.setPattern( "(^|[ \\t])--(noreplaygain|replaygain-accurate|replaygain-fast)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		replayGainCheckBox->setChecked( true );
		if ( regExp.cap( 2 ) == "noreplaygain" )
			replayGainComboBox->setCurrentItem( 0 );
		else if ( regExp.cap( 2 ) == "replaygain-accurate" )
			replayGainComboBox->setCurrentItem( 1 );
		else // replaygain-fast
			replayGainComboBox->setCurrentItem( 2 );
	}

	regExp.setPattern( "(^|[ \\t])-t([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		noINFOTagCheckBox->setChecked( true );

	regExp.setPattern( "(^|[ \\t])-o([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		copyFlagCheckBox->setChecked( true );

	regExp.setPattern( "(^|[ \\t])-c([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		copyrightFlagCheckBox->setChecked( true );


	/**
	* QUALITY SETTINGS
	*/

	regExp.setPattern( "(^|[ \\t])-q[ \\t]+([0-9])([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		algorithmsQualityCheckBox->setChecked( true );
		algorithmsQualityComboBox->setCurrentItem( regExp.cap( 2 ).toInt() );
	}
	else
	{
		regExp.setPattern( "(^|[ \\t])-(h|f)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
		{
			optimizationCheckBox->setChecked( true );
			optimizationComboBox->setCurrentItem( regExp.cap( 2 ) == "h" ? 0 : 1 );
		}
	}

	regExp.setPattern( "(^|[ \\t])-m[ \\t]+(m|j|f|s|d)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		stereoModeCheckBox->setChecked( true );
		QString mode = regExp.cap( 2 );

		int mode_idx;
		if ( mode == "m" )			mode_idx = 0;
		else if ( mode == "j" )		mode_idx = 1;
		else if ( mode == "f" )		mode_idx = 2;
		else if ( mode == "s" )		mode_idx = 3;
		else 						mode_idx = 4;

		stereoModeComboBox->setCurrentItem( mode_idx );
	}


	/**
	* MISC SETTINGS
	*/

	regExp.setPattern( "(^|[ \\t])--strictly-enforce-ISO([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		isoComplyCheckBox->setChecked( true );

	regExp.setPattern( "(^|[ \\t])-p([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		crcCheckBox->setChecked( true );

	regExp.setPattern( "(^|[ \\t])-d([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		differentBlockTypesCheckBox->setChecked( true );

	regExp.setPattern( "(^|[ \\t])--nores([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		noBitReservoirCheckBox->setChecked( true );


	/**
	* ATH SETTINGS
	*/

	regExp.setPattern( "(^|[ \\t])--noath([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		athControlCheckBox->setChecked( true );
		athControlComboBox->setCurrentItem( 0 );
	}
	else
	{
		regExp.setPattern( "(^|[ \\t])--(athonly|athshort)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
		{
			athControlCheckBox->setChecked( true );
			if ( regExp.cap( 2 ) == "athonly" )
				athControlComboBox->setCurrentItem( 1 );
			else
				athControlComboBox->setCurrentItem( 2 );
		}

		regExp.setPattern( "(^|[ \\t])--athtype[ \\t]+([0-2])([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
		{
			athShapeCheckBox->setChecked( true );
			athShapeComboBox->setCurrentItem( regExp.cap( 2 ).toInt() );
		}

		regExp.setPattern( "(^|[ \\t])--athlower[ \\t]+([0-9]+)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
		{
			athLowerCheckBox->setChecked( true );
			athLowerSpinBox->setValue( regExp.cap( 2 ).toInt() );
		}

		regExp.setPattern( "(^|[ \\t])--athaa-type[ \\t]+([1-3])([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
		{
			athAutoAdjustCheckBox->setChecked( true );
			athAATypeComboBox->setCurrentItem( regExp.cap( 2 ).toInt()-1 );

			regExp.setPattern( "(^|[ \\t])--athaa-sensitivity[ \\t]+([0-9]+)([ \\t]|$)" );
			if ( regExp.search( switches ) != -1 )
				athAASensitivitySpinBox->setValue( regExp.cap( 2 ).toInt() );
		}
	}
	changeItemATHControl();


	/**
	* PSY SETTINGS
	*/

	if ( ! athControlCheckBox->isChecked() || ! athControlComboBox->currentItem() == 1 )
	{
		regExp.setPattern( "(^|[ \\t])--(noshort|short|allshort)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
		{
			psyControlCheckBox->setChecked( true );
			if ( regExp.cap( 2 ) == "noshort" )
				psyControlComboBox->setCurrentItem( 0 );
			else if ( regExp.cap( 2 ) == "short" )
				psyControlComboBox->setCurrentItem( 1 );
			else // allshort
				psyControlComboBox->setCurrentItem( 2 );
		}

		regExp.setPattern( "(^|[ \\t])--cwlimit[ \\t]+([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
		{
			psyTonalityCheckBox->setChecked( true );
			psyTonalitySpinBox->setValue( (int)(regExp.cap( 2 ).toFloat()+0.5) );
		}

		regExp.setPattern( "(^|[ \\t])--notemp([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
			psyNoTempMaskingCheckBox->setChecked( true );

		regExp.setPattern( "(^|[ \\t])--nspsytune([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
			psyExperimentalTunningsCheckBox->setChecked( true );
	}

	/**
	* GENERAL SETTINGS
	*/

	regExp.setPattern( "(^|[ \\t])--resample[ \\t]+(8|11\\.025|12|16|22\\.05|24|32|44\\.1|48)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		resampleCheckBox->setChecked( true );
		int idx = 0;
		QString frecuency = regExp.cap( 2 );
		if ( frecuency == "8" )				idx = 0;
		else if ( frecuency == "11.025" )	idx = 1;
		else if ( frecuency == "12" )		idx = 2;
		else if ( frecuency == "16" )		idx = 3;
		else if ( frecuency == "22.05" )	idx = 4;
		else if ( frecuency == "24" )		idx = 5;
		else if ( frecuency == "32" )		idx = 6;
		else if ( frecuency == "44.1" )		idx = 7;
		else if ( frecuency == "48" )		idx = 8;
		resampleComboBox->setCurrentItem( idx );
	}

	regExp.setPattern( "(^|[ \\t])--scale[ \\t]+([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		scaleBothCheckBox->setChecked( true );
		scaleBothDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
	}

	regExp.setPattern( "(^|[ \\t])--scale-l[ \\t]+([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		scaleLeftCheckBox->setChecked( true );
		scaleLeftDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
	}

	regExp.setPattern( "(^|[ \\t])--scale-r[ \\t]+([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		scaleRightCheckBox->setChecked( true );
		scaleRightDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
	}


	regExp.setPattern( "(^|[ \\t])-k([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		noFiltersCheckBox->setChecked( true );
	else
	{
		regExp.setPattern( "(^|[ \\t])--highpass[ \\t]+([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
		{
			highpassFrecCheckBox->setChecked( true );
			highpassFrecDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );

			regExp.setPattern( "(^|[ \\t])--highpass-width[ \\t]+([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
			if ( regExp.search( switches ) != -1 )
			{
				highpassWidthCheckBox->setChecked( true );
				highpassWidthDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
			}
		}

		regExp.setPattern( "(^|[ \\t])--lowpass[ \\t]+([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
		{
			lowpassFrecCheckBox->setChecked( true );
			lowpassFrecDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );

			regExp.setPattern( "(^|[ \\t])--lowpass-width[ \\t]+([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
			if ( regExp.search( switches ) != -1 )
			{
				lowpassWidthCheckBox->setChecked( true );
				lowpassWidthDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
			}
		}
	}
}


QString LAMEEncoderDialog::switches()
{
	QString result;

	/**
	* BITRATE SETTINGS
	*/

	if ( freeFormatRadioButton->isChecked() )
		result = "--freeformat -b " + freeFormatSpinBox->cleanText();
	else
	{
		if ( minBitrateCheckBox->isChecked() )
		{
			if ( enforceMinBitrateCheckBox->isChecked() )
				result = " -F";

			QString bitrate;
			switch ( minBitrateComboBox->currentItem() )
			{
				case 0:		bitrate = "32";		break;
				case 1:		bitrate = "40";		break;
				case 2:		bitrate = "48";		break;
				case 3:		bitrate = "56";		break;
				case 4:		bitrate = "64";		break;
				case 5:		bitrate = "80";		break;
				case 6:		bitrate = "96";		break;
				case 7:		bitrate = "112";	break;
				case 8:		bitrate = "128";	break;
				case 9:		bitrate = "160";	break;
				case 10:	bitrate = "192";	break;
				case 11:	bitrate = "224";	break;
				case 12:	bitrate = "256";	break;
				case 13:	bitrate = "320";	break;
			}
			result += " -b " + bitrate;
		}

		if ( bitrateModeComboBox->currentItem() == 1 ) // ABR
			result += " --abr " + avgBitrateSpinBox->cleanText();
		else if ( bitrateModeComboBox->currentItem() != 0 ) // CBR
		{
			if ( bitrateModeComboBox->currentItem() == 2 ) // VBR OLD
				result += " --vbr-old";
			else if ( bitrateModeComboBox->currentItem() == 3 ) // VBR NEW
				result += " --vbr-new";

			if ( vbrQualityCheckBox->isChecked() )
				result += " -V " + QString::number( vbrQualityComboBox->currentItem() );
		}

		if ( bitrateModeComboBox->currentItem() != 0 // CBR
			  && maxBitrateCheckBox->isChecked() )
		{
			QString bitrate;
			switch ( maxBitrateComboBox->currentItem() )
			{
				case 0:		bitrate = "32";		break;
				case 1:		bitrate = "40";		break;
				case 2:		bitrate = "48";		break;
				case 3:		bitrate = "56";		break;
				case 4:		bitrate = "64";		break;
				case 5:		bitrate = "80";		break;
				case 6:		bitrate = "96";		break;
				case 7:		bitrate = "112";	break;
				case 8:		bitrate = "128";	break;
				case 9:		bitrate = "160";	break;
				case 10:	bitrate = "192";	break;
				case 11:	bitrate = "224";	break;
				case 12:	bitrate = "256";	break;
				case 13:	bitrate = "320";	break;
			}
			result += " -B " + bitrate;
		}
	}


	/**
	* METADATA SETTINGS
	*/

	if ( replayGainCheckBox->isChecked() )
	{
		if (replayGainComboBox->currentItem() == 0 )
			result += " --noreplaygain";
		else if (replayGainComboBox->currentItem() == 1 )
			result += " --replaygain-accurate";
		else
			result += " --replaygain-fast";
	}

	if ( noINFOTagCheckBox->isChecked() )
		result += " -t";

	if ( copyFlagCheckBox->isChecked() )
		result += " -o";

	if ( copyrightFlagCheckBox->isChecked() )
		result += " -c";


	/**
	* QUALITY SETTINGS
	*/

	if ( algorithmsQualityCheckBox->isChecked() )
		result += " -q " + QString::number( algorithmsQualityComboBox->currentItem() );
	else if ( optimizationCheckBox->isChecked() )
		result += (optimizationComboBox->currentItem() == 0) ? " -h" : " -f";

	if ( stereoModeCheckBox->isChecked() )
	{
		if ( stereoModeComboBox->currentItem() == 0 )		result += " -m m";
		else if ( stereoModeComboBox->currentItem() == 1 )	result += " -m j";
		else if ( stereoModeComboBox->currentItem() == 2 )	result += " -m f";
		else if ( stereoModeComboBox->currentItem() == 3 )	result += " -m s";
		else 												result += " -m d";
	}


	/**
	* MISC SETTINGS
	*/

	if ( isoComplyCheckBox->isChecked() )
		result += " --strictly-enforce-ISO";

	if ( crcCheckBox->isChecked() )
		result += " -p";

	if ( differentBlockTypesCheckBox->isChecked() )
		result += " -d";

	if ( noBitReservoirCheckBox->isChecked() )
		result += " --nores";


	/**
	* ATH SETTINGS
	*/

	if ( athControlCheckBox->isChecked() && athControlComboBox->currentItem() == 0 )
		result += " --noath";
	else
	{
		if ( athControlCheckBox->isChecked() )
		{
			if ( athControlComboBox->currentItem() == 1 )
				result += " --athonly";
			else
				result += " --athshort";
		}

		if ( athShapeCheckBox->isChecked() )
			result += " --athtype " + QString::number( athShapeComboBox->currentItem() );

		if ( athLowerCheckBox->isChecked() )
			result += " --athlower " + QString::number( athLowerSpinBox->value() );

		if ( athAutoAdjustCheckBox->isChecked() )
		{
			result += " --athaa-type " + QString::number( athAATypeComboBox->currentItem()+1 );
			if ( athAASensitivityCheckBox->isChecked() )
				result += " --athaa-sensitivity " + QString::number( athAASensitivitySpinBox->value() );
		}
	}

	/**
	* PSY SETTINGS
	*/

	if ( ! athControlCheckBox->isChecked() || ! athControlComboBox->currentItem() == 1 )
	{
		if ( psyControlCheckBox->isChecked() )
		{
			if ( psyControlComboBox->currentItem() == 0 )
				result += " --noshort";
			else if ( psyControlComboBox->currentItem() == 1 )
				result += " --short";
			else
				result += " --allshort";
		}

		if ( psyTonalityCheckBox->isChecked() )
			result += " --cwlimit " + psyTonalitySpinBox->cleanText();

		if ( psyNoTempMaskingCheckBox->isChecked() )
			result += " --notemp";

		if ( psyExperimentalTunningsCheckBox->isChecked() )
			result += " --nspsytune";
	}

	/**
	* GENERAL SETTINGS
	*/

	if ( resampleCheckBox->isChecked() )
	{
		QString frecuency;
		switch ( resampleComboBox->currentItem() )
		{
			case 0: frecuency = "8";		break;
			case 1: frecuency = "11.025";	break;
			case 2: frecuency = "12";		break;
			case 3: frecuency = "16";		break;
			case 4: frecuency = "22.05";	break;
			case 5: frecuency = "24";		break;
			case 6: frecuency = "32";		break;
			case 7: frecuency = "44.1";		break;
			case 8: frecuency = "48";		break;
		}
		result += " --resample " + frecuency;
	}

	if ( scaleBothCheckBox->isChecked() )
		result += " --scale " + scaleBothDecSpinBox->cleanText();

	if ( scaleLeftCheckBox->isChecked() )
		result += " --scale-l " + scaleLeftDecSpinBox->cleanText();

	if ( scaleRightCheckBox->isChecked() )
		result += " --scale-r " + scaleRightDecSpinBox->cleanText();

	if ( noFiltersCheckBox->isChecked() )
		result += " -k";
	else
	{
		if ( highpassFrecCheckBox->isChecked() )
		{
			result += " --highpass " + QString::number( highpassFrecDecSpinBox->decimalValue(), 'g', 5 );
			if ( highpassWidthCheckBox->isChecked() )
				result += " --highpass-width " + QString::number( highpassWidthDecSpinBox->decimalValue(), 'g', 5 );
		}

		if ( lowpassFrecCheckBox->isChecked() )
		{
			result += " --lowpass " + QString::number( lowpassFrecDecSpinBox->decimalValue(), 'g', 5 );
			if ( lowpassWidthCheckBox->isChecked() )
				result += " --lowpass-width " + QString::number( lowpassWidthDecSpinBox->decimalValue(), 'g', 5 );
		}
	}

	return result.simplifyWhiteSpace();
}
