#ifndef TRANSKODE_LAMEENCODERDIALOGBASE_UI_H
#define TRANSKODE_LAMEENCODERDIALOGBASE_UI_H

/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <kdecspinbox.h>

void LAMEEncoderDialogBase::setDisabledHighpassFrec( bool disabled )
{
	highpassFrecCheckBox->setDisabled( disabled );

	if ( disabled && highpassFrecCheckBox->isChecked() )
		highpassFrecCheckBox->setChecked( false );

	bool enableSubControls = ! disabled && highpassFrecCheckBox->isChecked();
	highpassFrecLabel->setEnabled( enableSubControls );
	highpassFrecDecSpinBox->setEnabled( enableSubControls );

	setEnabledHighpassWidth( enableSubControls );
}


void LAMEEncoderDialogBase::setDisabledLowpassFrec( bool disabled )
{
	lowpassFrecCheckBox->setDisabled( disabled );

	if ( disabled && lowpassFrecCheckBox->isChecked() )
		lowpassFrecCheckBox->setChecked( false );

	bool enableSubControls = ! disabled && lowpassFrecCheckBox->isChecked();
	lowpassFrecLabel->setEnabled( enableSubControls );
	lowpassFrecDecSpinBox->setEnabled( enableSubControls );

	setEnabledLowpassWidth( enableSubControls );
}


void LAMEEncoderDialogBase::setEnabledHighpassWidth( bool enabled )
{
	highpassWidthCheckBox->setEnabled( enabled );

	if ( ! enabled && highpassWidthCheckBox->isChecked() )
		highpassWidthCheckBox->setChecked( false );

	bool enableSubControls = enabled && highpassWidthCheckBox->isChecked();
	highpassWidthLabel->setEnabled( enableSubControls );
	highpassWidthDecSpinBox->setEnabled( enableSubControls );
}


void LAMEEncoderDialogBase::setEnabledLowpassWidth( bool enabled )
{
	lowpassWidthCheckBox->setEnabled( enabled );

	if ( ! enabled && lowpassWidthCheckBox->isChecked() )
		lowpassWidthCheckBox->setChecked( false );

	bool enableSubControls = enabled && lowpassWidthCheckBox->isChecked();
	lowpassWidthLabel->setEnabled( enableSubControls );
	lowpassWidthDecSpinBox->setEnabled( enableSubControls );
}


void LAMEEncoderDialogBase::changeItemATHControl()
{
	bool athEnabled = athControlComboBox->currentItem() != 0;
	bool psyEnabled = athControlComboBox->currentItem() != 1;

	athShapeCheckBox->setEnabled( athEnabled );
	athLowerCheckBox->setEnabled( athEnabled );
	athAutoAdjustCheckBox->setEnabled( athEnabled );

	psyControlCheckBox->setEnabled( psyEnabled );
	psyTonalityCheckBox->setEnabled( psyEnabled );
	psyNoTempMaskingCheckBox->setEnabled( psyEnabled );
	psyExperimentalTunningsCheckBox->setEnabled( psyEnabled );

	if ( athControlComboBox->currentItem() == 0 ) // don't use ATH entry
	{
		athShapeCheckBox->setChecked( false );
		athLowerCheckBox->setChecked( false );
		athAutoAdjustCheckBox->setChecked( false );
	}
	else if ( athControlComboBox->currentItem() == 1 ) // Use only ATH entry
	{
		psyControlCheckBox->setChecked( false );
		psyTonalityCheckBox->setChecked( false );
		psyNoTempMaskingCheckBox->setChecked( false );
		psyExperimentalTunningsCheckBox->setEnabled( false );
	}
}


void LAMEEncoderDialogBase::changeItemBitrateMode()
{
	bool minEnabled = true;
	bool avgEnabled = bitrateModeComboBox->currentItem() == 1;
	bool maxEnabled = bitrateModeComboBox->currentItem() != 0;

	minBitrateCheckBox->setEnabled( minEnabled );
	if ( ! minEnabled )
		minBitrateCheckBox->setChecked( false );

	avgBitrateLabel1->setEnabled( avgEnabled );
	avgBitrateLabel2->setEnabled( avgEnabled );
	avgBitrateSpinBox->setEnabled( avgEnabled );

	maxBitrateCheckBox->setEnabled( maxEnabled );
	if ( ! maxEnabled )
		maxBitrateCheckBox->setChecked( false );

	enforceMinBitrateCheckBox->setEnabled( maxEnabled );
	if ( ! maxEnabled )
		enforceMinBitrateCheckBox->setChecked( false );

	if ( bitrateModeComboBox->currentItem() == 2 ||	// VBR old
		  bitrateModeComboBox->currentItem() == 3)	// VBR new
		vbrQualityCheckBox->setEnabled( true );
	else
	{
		vbrQualityCheckBox->setChecked( false );
		vbrQualityCheckBox->setEnabled( false );
	}

}

void LAMEEncoderDialogBase::toggleFreeFormat( bool enabled )
{
	freeFormatSpinBox->setEnabled( enabled );
	freeFormatLabel->setEnabled( enabled );

	if ( enabled )
	{
		bitrateModeComboBox->setCurrentItem( 0 ); // CBR
		changeItemBitrateMode();
		bitrateModeComboBox->setEnabled( false );
		minBitrateCheckBox->setEnabled( false );
	}
	else
	{
		bitrateModeComboBox->setEnabled( true );
		minBitrateCheckBox->setEnabled( true );
	}
}


void LAMEEncoderDialogBase::toggleDownmix( bool enabled )
{
	if ( enabled )
	{
		//stereo_mode_combobox->setCurrentItem( 0 ); //MONO
		stereoModeCheckBox->setEnabled( false );
		stereoModeCheckBox->setChecked( false );
	}
	else
		stereoModeCheckBox->setEnabled( true );
}


void LAMEEncoderDialogBase::toggleATHAutoAdjust( bool enabled )
{
	athAATypeLabel->setEnabled( enabled );
	athAATypeComboBox->setEnabled( enabled );
	athAASensitivityCheckBox->setEnabled( enabled );

	if ( ! enabled )
		athAASensitivityCheckBox->setChecked( false );
}

#endif
