/***************************************************************************
 *   Copyright (C) 2006 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include "lpacencoderdialog.h"

#include <qregexp.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <kcombobox.h>
#include <knuminput.h>

LPACEncoderDialog::LPACEncoderDialog( QWidget* parent, const char* name ):
	LPACEncoderDialogBase( parent, name ) {}

LPACEncoderDialog::~LPACEncoderDialog() {}

void LPACEncoderDialog::setSwitches( const QString& switches )
{
	QRegExp regExp;

	regExp.setPattern( "(^|[ \\t])-([0-5])([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		int mode = regExp.cap( 2 ).toInt();
		if ( mode > 0 )
		{
			compressionLevelRadioButton->setChecked( true );
			compressionLevelComboBox->setEnabled( true );
			compressionLevelComboBox->setCurrentItem( mode - 1 );
		}
		else
		{
			customEncodingRadioButton->setChecked( true );
			toggledCustomEncoding( true );

			// -b#: Block length: 0 = auto (default), 256, 512, 1024, 2048, 4096, 8192
			regExp.setPattern( "(^|[ \\t])-b(0|256|512|1024|2048|4096|8192)([ \\t]|$)" );
			if ( regExp.search( switches ) != -1 )
			{
				blockLengthCheckBox->setChecked( true );
				blockLengthComboBox->setEnabled( true );
				switch ( regExp.cap( 2 ).toInt() )
				{
					case 0:		blockLengthComboBox->setCurrentItem( 0 );	break;
					case 256:	blockLengthComboBox->setCurrentItem( 1 );	break;
					case 512:	blockLengthComboBox->setCurrentItem( 2 );	break;
					case 1024:	blockLengthComboBox->setCurrentItem( 3 );	break;
					case 2048:	blockLengthComboBox->setCurrentItem( 4 );	break;
					case 4096:	blockLengthComboBox->setCurrentItem( 5 );	break;
					case 8192:	blockLengthComboBox->setCurrentItem( 6 );	break;
					default:												break;
				}
			}

			// -w#: Window: 0 = Hanning (default), 1 = Hamming, 2 = Rect, 3 = Blackman
			regExp.setPattern( "(^|[ \\t])-w([0-3])([ \\t]|$)" );
			if ( regExp.search( switches ) != -1 )
			{
				windowTypeCheckBox->setChecked( true );
				windowTypeComboBox->setEnabled( true );
				windowTypeComboBox->setCurrentItem( regExp.cap( 2 ).toInt() );
			}

			regExp.setPattern( "(^|[ \\t])-p([0-9]+)([ \\t]|$)" );
			if ( regExp.search( switches ) != -1 )
			{
				predictorOrderCheckBox->setChecked( true );
				predictorOrderSpinBox->setEnabled( true );
				int order = regExp.cap( 2 ).toInt();
				predictorOrderSpinBox->setValue( order > 60 ? 60 : order );
			}

			regExp.setPattern( "(^|[ \\t])-f([ \\t]|$)" );
			if ( regExp.search( switches ) != -1 )
				fullSearchCheckBox->setChecked( true );

			regExp.setPattern( "(^|[ \\t])-a([ \\t]|$)" );
			if ( regExp.search( switches ) != -1 )
				adaptativeEntropyCheckBox->setChecked( true );
		}
	}

	//-u#: Use specific file format version: 2, 4, 5 or 6 (default)
	regExp.setPattern( "(^|[ \\t])-u(2|4|5|6)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		int ver = regExp.cap( 2 ).toInt();
		if ( ver == 6 || ! customEncodingRadioButton->isChecked() )
		{
			fileFormatCheckBox->setChecked( true );
			fileFormatComboBox->setEnabled( ! customEncodingRadioButton->isChecked() );
			switch ( ver )
			{
				case 2:		fileFormatComboBox->setCurrentItem( 0 );	break;
				case 4:		fileFormatComboBox->setCurrentItem( 1 );	break;
				case 5:		fileFormatComboBox->setCurrentItem( 2 );	break;
				case 6:		fileFormatComboBox->setCurrentItem( 3 );	break;
				default:												break;
			}
		}
	}

	regExp.setPattern( "(^|[ \\t])-r([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		randomAccesCheckBox->setChecked( true );

	regExp.setPattern( "(^|[ \\t])-i([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		independantChannelsCheckBox->setChecked( true );

	regExp.setPattern( "(^|[ \\t])-c([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		verifyOutputFileCheckBox->setChecked( true );
}

QString LPACEncoderDialog::switches()
{
	QString result;

	if ( compressionLevelRadioButton->isChecked() )
		result += "-" + QString::number( compressionLevelComboBox->currentItem()+1 );
	else if ( customEncodingRadioButton->isChecked() )
	{
		result += "-0";

		if ( blockLengthCheckBox->isChecked() )
		{
			int size = blockLengthComboBox->currentItem() == 0 ? 0 : blockLengthComboBox->currentText().toInt();
			result += " -b" + QString::number( size );
		}

		if ( windowTypeCheckBox->isChecked() )
			result += " -w" + QString::number( windowTypeComboBox->currentItem() );

		if ( predictorOrderCheckBox->isChecked() )
			result += " -p" + QString::number( predictorOrderSpinBox->value() );

		if ( fullSearchCheckBox->isChecked() )
			result += " -f";

		if ( adaptativeEntropyCheckBox->isChecked() )
			result += " -a";
	}

	if ( fileFormatCheckBox->isChecked() )
		result += " -u" + fileFormatComboBox->currentText();

	if ( randomAccesCheckBox->isChecked() )
		result += " -r";

	if ( independantChannelsCheckBox->isChecked() )
		result += " -i";

	if ( verifyOutputFileCheckBox->isChecked() )
		result += " -c";

	return result.simplifyWhiteSpace();
}
