#ifndef TRANSKODE_LPACENCODERDIALOGBASE_UI_H
#define TRANSKODE_LPACENCODERDIALOGBASE_UI_H

/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif


void LPACEncoderDialogBase::toggledCompressionLevel( bool checked )
{
	customEncodingRadioButton->setEnabled( ! checked );
	compressionLevelComboBox->setEnabled( checked );

	if ( checked )
	{
		changedCompressionLevel( compressionLevelComboBox->currentItem() );

		customEncodingRadioButton->setChecked( false );
		blockLengthCheckBox->setEnabled( false );
		blockLengthCheckBox->setChecked( false );
		blockLengthComboBox->setEnabled( false );
		windowTypeCheckBox->setEnabled( false );
		windowTypeCheckBox->setChecked( false );
		windowTypeComboBox->setEnabled( false );
		predictorOrderCheckBox->setEnabled( false );
		predictorOrderCheckBox->setChecked( false );
		predictorOrderSpinBox->setEnabled( false );
		fullSearchCheckBox->setEnabled( false );
		fullSearchCheckBox->setChecked( false );
		adaptativeEntropyCheckBox->setEnabled( false );
		adaptativeEntropyCheckBox->setChecked( false );

		if ( fileFormatCheckBox->isChecked() )
			fileFormatComboBox->setEnabled( true );
	}
	else
		randomAccesCheckBox->setEnabled( true );
}

void LPACEncoderDialogBase::toggledCustomEncoding( bool checked )
{
	compressionLevelRadioButton->setEnabled( ! checked );

	if ( checked )
	{
		randomAccesCheckBox->setEnabled( true );

		compressionLevelRadioButton->setChecked( false );
		compressionLevelComboBox->setEnabled( false );
		fileFormatComboBox->setCurrentItem( 3 );
		fileFormatComboBox->setEnabled( false );
	}
	else
	{
		blockLengthCheckBox->setChecked( false );
		blockLengthComboBox->setEnabled( false );
		windowTypeCheckBox->setChecked( false );
		windowTypeComboBox->setEnabled( false );
		predictorOrderCheckBox->setChecked( false );
		predictorOrderSpinBox->setEnabled( false );
		fullSearchCheckBox->setChecked( false );
		adaptativeEntropyCheckBox->setChecked( false );

		if ( fileFormatCheckBox->isChecked() )
			fileFormatComboBox->setEnabled( true );
	}

	blockLengthCheckBox->setEnabled( checked );
	windowTypeCheckBox->setEnabled( checked );
	predictorOrderCheckBox->setEnabled( checked );
	fullSearchCheckBox->setEnabled( checked );
	adaptativeEntropyCheckBox->setEnabled( checked );
}


void LPACEncoderDialogBase::toggleUseSpecificVersion( bool checked )
{
	fileFormatComboBox->setEnabled( checked && ! customEncodingRadioButton->isChecked() );
}

void LPACEncoderDialogBase::changedCompressionLevel( int index )
{
	if ( index > 0 )
		randomAccesCheckBox->setEnabled( true );
	else
	{
		randomAccesCheckBox->setEnabled( false );
		randomAccesCheckBox->setChecked( false );
	}
}

#endif
