/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "macencoderdialog.h"

#include <qregexp.h>
#include <qradiobutton.h>

MACEncoderDialog::MACEncoderDialog( QWidget* parent, const char* name ):
	MACEncoderDialogBase( parent, name ) {}

MACEncoderDialog::~MACEncoderDialog() {}

void MACEncoderDialog::setSwitches( const QString& switches )
{
	if ( switches.contains( QRegExp( "(^|[ \\t])-c1000([ \\t]|$)" ) ) )
		fastRadioButton->setChecked( true );
	else if ( switches.contains( QRegExp( "(^|[ \\t])-c2000([ \\t]|$)" ) ) )
		normalRadioButton->setChecked( true );
	else if ( switches.contains( QRegExp( "(^|[ \\t])-c3000([ \\t]|$)" ) ) )
		highRadioButton->setChecked( true );
	else if ( switches.contains( QRegExp( "(^|[ \\t])-c4000([ \\t]|$)" ) ) )
		extrahighRadioButton->setChecked( true );
	else if ( switches.contains( QRegExp( "(^|[ \\t])-c5000([ \\t]|$)" ) ) )
		insaneRadioButton->setChecked( true );
}

QString MACEncoderDialog::switches()
{
	QString result;

	if ( fastRadioButton->isChecked() )
		result = "-c1000";
	else if ( normalRadioButton->isChecked() )
		result = "-c2000";
	else if ( highRadioButton->isChecked() )
		result = "-c3000";
	else if ( extrahighRadioButton->isChecked() )
		result = "-c4000";
	else // insaneRadioButton->isChecked()
		result = "-c5000";

	return result;
}
