#ifndef TRANSKODE_MACENCODERPLUGIN_H
#define TRANSKODE_MACENCODERPLUGIN_H

/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <encoderplugin.h>
#include "macencoderdialog.h"

#include <audioproperties.h>
#include <mpcfile.h>

namespace TransKode
{
	class MACEncoderPlugin : public EncoderPlugin
	{
		friend class PluginsManager;

		public:

			virtual bool configurable() const
			{
				return true;
			}

			virtual void setupArgs( ProcessHandler& proc, const QString& src, const QString& dst, const QString& switches, const Metadata& ) const
			{
				proc.clearArguments();
				bool pMode = proc.getShellParsingMode();
				proc.setShellParsingMode( false );
				proc << programPath() << src << dst;
				proc.setShellParsingMode( true );
				proc << switches;
				proc.setShellParsingMode( pMode );
			}

			virtual ProgressParser* newProgressParser() const
			{
				return new RegExpProgressParser( ".*Progress: (\\d+\\.\\d+)%", RegExpProgressParser::float_percentage );
			}

			virtual TagLib::File* newTagLibFile( const char* fileName, bool readAudioProp, int audioPropStyle ) const
			{
				return new TagLib::MPC::File( fileName, readAudioProp, (TagLib::AudioProperties::ReadStyle)audioPropStyle );
			}

		protected:

			virtual EncoderDialog* _newEncoderDialog( QWidget* parent=0, const char* name=0 ) const
			{
				return new MACEncoderDialog( parent, name );
			}

			MACEncoderPlugin():EncoderPlugin( "Monkey's Audio", QString::null, "mac", QStringList::split( ":", "ape:mac:*" ) ) {}

			~MACEncoderPlugin() {}
	};
}

#endif

