/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "mppencencoderdialog.h"

#include <qregexp.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <kcombobox.h>
#include <kdecspinbox.h>

MPPEncEncoderDialog::MPPEncEncoderDialog( QWidget* parent, const char* name ):
	MPPEncEncoderDialogBase( parent, name ) {}

MPPEncEncoderDialog::~MPPEncEncoderDialog() {}

void MPPEncEncoderDialog::setSwitches( const QString& switches )
{
	QRegExp regExp;

	/**
	* QUALITY / MASKING
	*/

	regExp.setPattern( "(^|[ \\t])--(telephone|thumb|radio|standard|xtreme|insane|braindead)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		profileRadioButton->setChecked( true );
		if ( regExp.cap( 2 ) == "telephone" )		profileComboBox->setCurrentItem( 0 );
		else if ( regExp.cap( 2 ) == "thumb" )		profileComboBox->setCurrentItem( 1 );
		else if ( regExp.cap( 2 ) == "radio" )		profileComboBox->setCurrentItem( 2 );
		else if ( regExp.cap( 2 ) == "standard" )	profileComboBox->setCurrentItem( 3 );
		else if ( regExp.cap( 2 ) == "xtreme" )		profileComboBox->setCurrentItem( 4 );
		else if ( regExp.cap( 2 ) == "insane" )		profileComboBox->setCurrentItem( 5 );
		else 										profileComboBox->setCurrentItem( 6 );
	}
	else
	{
		regExp.setPattern( "(^|[ \\t])--quality[ \\t]+([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
		{
			qualityRadioButton->setChecked( true );
			qualityDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
		}
	}

	regExp.setPattern( "(^|[ \\t])--minSMR[ \\t]+([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		minSMRCheckBox->setChecked( true );
		minSMRDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
	}

	regExp.setPattern( "(^|[ \\t])--nmt[ \\t]+([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		nmtCheckBox->setChecked( true );
		nmtDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
	}

	regExp.setPattern( "(^|[ \\t])--tmn[ \\t]+([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		tmnCheckBox->setChecked( true );
		tmnDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
	}

	regExp.setPattern( "(^|[ \\t])--pns[ \\t]+([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		pnsCheckBox->setChecked( true );
		pnsDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
	}


/**
 * AUDIO PROCESSING
*/

	regExp.setPattern( "(^|[ \\t])--skip[ \\t]+([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		startPositionCheckBox->setChecked( true );
		startPositionDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
	}

	regExp.setPattern( "(^|[ \\t])--dur[ \\t]+([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		durationCheckBox->setChecked( true );
		durationDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
	}

	regExp.setPattern( "(^|[ \\t])--fade[ \\t]+([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		fadeInCheckBox->setChecked( true );
		fadeInDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
		fadeOutCheckBox->setChecked( true );
		fadeOutDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
	}
	else
	{
		regExp.setPattern( "(^|[ \\t])--fadein[ \\t]+([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
		{
			fadeInCheckBox->setChecked( true );
			fadeInDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
		}

		regExp.setPattern( "(^|[ \\t])--fadeout[ \\t]+([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
		{
			fadeOutCheckBox->setChecked( true );
			fadeOutDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
		}
	}

	if ( fadeInCheckBox->isChecked() || fadeOutCheckBox->isChecked() )
	{
		regExp.setPattern( "(^|[ \\t])--fadeshape[ \\t]+([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
		{
			fadeShapeCheckBox->setChecked( true );
			fadeShapeDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
		}
	}

	regExp.setPattern( "(^|[ \\t])--scale[ \\t]+([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		leftScaleCheckBox->setChecked( true );
		leftScaleDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
		rightScaleCheckBox->setChecked( true );
		rightScaleDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
	}
	else
	{
		regExp.setPattern( "(^|[ \\t])--scale[ \\t]+([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+),([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
		{
			leftScaleCheckBox->setChecked( true );
			leftScaleDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
			rightScaleCheckBox->setChecked( true );
			rightScaleDecSpinBox->setDecimalValue( regExp.cap( 3 ).toDouble() );
		}
	}

	regExp.setPattern( "(^|[ \\t])--bw[ \\t]+([0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		bandwidthCheckBox->setChecked( true );
		bandwidthSpinBox->setValue( regExp.cap( 2 ).toInt() );
	}


	/**
	* MISC SETTINGS
	*/

	regExp.setPattern( "(^|[ \\t])--ms[ \\t]+(0|1|2|3|10|11|12|13|15)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		msModeCheckBox->setChecked( true );
		switch ( regExp.cap( 2 ).toInt() )
		{
			case 0:		msModeComboBox->setCurrentItem( 0 );	break;
			case 1:		msModeComboBox->setCurrentItem( 1 );	break;
			case 2:		msModeComboBox->setCurrentItem( 2 );	break;
			case 3:		msModeComboBox->setCurrentItem( 3 );	break;
			case 10:	msModeComboBox->setCurrentItem( 4 );	break;
			case 11:	msModeComboBox->setCurrentItem( 5 );	break;
			case 12:	msModeComboBox->setCurrentItem( 6 );	break;
			case 13:	msModeComboBox->setCurrentItem( 7 );	break;
			case 15:	msModeComboBox->setCurrentItem( 8 );	break;
		}
	}

	regExp.setPattern( "(^|[ \\t])--ans[ \\t]+([0-6]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		noiseShapingOrderCheckBox->setChecked( true );
		noiseShapingOrderComboBox->setCurrentItem( regExp.cap( 2 ).toInt() );
	}

	regExp.setPattern( "(^|[ \\t])--cvd[ \\t]+([0-2]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		clearVoiceDetectionCheckBox->setChecked( true );
		clearVoiceDetectionComboBox->setCurrentItem( regExp.cap( 2 ).toInt() );
	}

	regExp.setPattern( "(^|[ \\t])--minval[ \\t]+([1-3]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		minvalCheckBox->setChecked( true );
		minvalComboBox->setCurrentItem( regExp.cap( 2 ).toInt()-1 );
	}

	regExp.setPattern( "(^|[ \\t])--shortthr[ \\t]+([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		fftThresholdCheckBox->setChecked( true );
		fftThresholdDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
	}

	regExp.setPattern( "(^|[ \\t])--transdet[ \\t]+([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		slewrateCheckBox->setChecked( true );
		slewrateDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
	}

	regExp.setPattern( "(^|[ \\t])--noxlevel([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		oldClippingSolvingCheckBox->setChecked( true );


	/**
	 * LHQ
	*/

	regExp.setPattern( "(^|[ \\t])--ltq[ \\t]+([0-5])([0-9][0-9])([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		lhqModeCheckBox->setChecked( true );
		lhqModeComboBox->setCurrentItem( regExp.cap( 2 ).toInt() );
		lhqHighFrecRollOffSpinBox->setValue( regExp.cap( 3 ).toInt() );
	}

	regExp.setPattern( "(^|[ \\t])--ltq_gain[ \\t]+([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		lhqGainCheckBox->setChecked( true );
		lhqGainDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
	}

	regExp.setPattern( "(^|[ \\t])--ltq_max[ \\t]+([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		lhqMaxLevelCheckBox->setChecked( true );
		lhqMaxLevelDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
	}

	regExp.setPattern( "(^|[ \\t])--ltq_var[ \\t]+([01])([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		adaptativeLHQCheckBox->setChecked( true );
		adaptativeLHKComboBox->setCurrentItem( regExp.cap( 2 ).toInt() );
	}

	regExp.setPattern( "(^|[ \\t])--tmpMask[ \\t]+([01])([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		exploitPostMaskingCheckBox->setChecked( true );
		exploitPostMaskingComboBox->setCurrentItem( regExp.cap( 2 ).toInt() );
	}
}

QString MPPEncEncoderDialog::switches()
{
	QString result;

	if ( profileRadioButton->isChecked() )
		result += "--" + profileComboBox->currentText().lower();
	else if ( qualityRadioButton->isChecked() )
		result += "--quality " + qualityDecSpinBox->cleanText();


	if ( minSMRCheckBox->isChecked() )
		result += " --minSMR " + minSMRDecSpinBox->cleanText();

	if ( nmtCheckBox->isChecked() )
		result += " --nmt " + nmtDecSpinBox->cleanText();

	if ( tmnCheckBox->isChecked() )
		result += " --tmn " + tmnDecSpinBox->cleanText();

	if ( pnsCheckBox->isChecked() )
		result += " --pns " + pnsDecSpinBox->cleanText();


	/**
	* AUDIO PROCESSING
	*/

	if ( startPositionCheckBox->isChecked() )
		result += " --skip " + startPositionDecSpinBox->cleanText();

	if ( durationCheckBox->isChecked() )
		result += " --dur " + durationDecSpinBox->cleanText();

	if ( fadeInCheckBox->isChecked() )
		result += " --fadein " + fadeInDecSpinBox->cleanText();

	if ( fadeOutCheckBox->isChecked() )
		result += " --fadeout " + fadeOutDecSpinBox->cleanText();

	if ( fadeShapeCheckBox->isChecked() )
		result += " --fadeshape " + fadeShapeDecSpinBox->cleanText();

	if ( leftScaleCheckBox->isChecked() || rightScaleCheckBox->isChecked() )
	{
		if ( leftScaleDecSpinBox->value() == rightScaleDecSpinBox->value() )
			result += " --scale " + leftScaleDecSpinBox->cleanText();
		else
			result += " --scale " + leftScaleDecSpinBox->cleanText() + "," + rightScaleDecSpinBox->cleanText();
	}

	if ( bandwidthCheckBox->isChecked() )
		result += " --bw " + bandwidthSpinBox->cleanText();


	/**
	* MISC SETTINGS
	*/

	if ( msModeCheckBox->isChecked() )
	{
		switch ( msModeComboBox->currentItem() )
		{
			case 0:	result += " --ms 0";	break;
			case 1:	result += " --ms 1";	break;
			case 2:	result += " --ms 2";	break;
			case 3:	result += " --ms 3";	break;
			case 4:	result += " --ms 10";	break;
			case 5:	result += " --ms 11";	break;
			case 6:	result += " --ms 12";	break;
			case 7:	result += " --ms 13";	break;
			case 8:	result += " --ms 15";	break;
		}
	}

	if ( noiseShapingOrderCheckBox->isChecked() )
		result += " --ans " + QString::number( noiseShapingOrderComboBox->currentItem() );

	if ( clearVoiceDetectionCheckBox->isChecked() )
		result += " --cvd " + QString::number( clearVoiceDetectionComboBox->currentItem() );

	if ( minvalCheckBox->isChecked() )
		result += " --minval " + QString::number( minvalComboBox->currentItem()+1 );

	if ( fftThresholdCheckBox->isChecked() )
		result += " --shortthr " + fftThresholdDecSpinBox->cleanText();

	if ( slewrateCheckBox->isChecked() )
		result += " --transdet " + slewrateDecSpinBox->cleanText();

	if ( oldClippingSolvingCheckBox->isChecked() )
		result += " --noxlevel";


	/**
	 * LHQ
	*/

	if ( lhqModeCheckBox->isChecked() )
		result += " --ltq " + QString::number( lhqModeComboBox->currentItem() ) + lhqHighFrecRollOffSpinBox->cleanText();

	if ( lhqGainCheckBox->isChecked() )
		result += " --ltq_gain " + lhqGainDecSpinBox->cleanText();

	if ( lhqMaxLevelCheckBox->isChecked() )
		result += " --ltq_max " + lhqMaxLevelDecSpinBox->cleanText();

	if ( adaptativeLHQCheckBox->isChecked() )
		result += " --ltq_var " + QString::number( adaptativeLHKComboBox->currentItem() );

	if ( exploitPostMaskingCheckBox->isChecked() )
		result += " --tmpMask " + QString::number( exploitPostMaskingComboBox->currentItem() );

	return result.simplifyWhiteSpace();
}
