/***************************************************************************
 *   Copyright (C) 2006 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include "ofrencoderdialog.h"

#include <qregexp.h>
#include <qcheckbox.h>
#include <kcombobox.h>

OFREncoderDialog::OFREncoderDialog( QWidget* parent, const char* name ):
	OFREncoderDialogBase( parent, name ) {}

OFREncoderDialog::~OFREncoderDialog() {}

void OFREncoderDialog::setSwitches( const QString& switches )
{
	QRegExp regExp;

	regExp.setPattern( "(^|[ \\t])--maximumcompression([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		compressionLevelCheckBox->setChecked( true );
		compressionLevelComboBox->setEnabled( true );
		compressionLevelComboBox->setCurrentItem( 8 );
		optimizationCheckBox->setEnabled( false );
		seekingCheckBox->setEnabled( false );
	}
	else
	{
		// --mode {fast|normal*|high|extra|best|highnew|extranew|bestnew}
		regExp.setPattern( "(^|[ \\t])--mode[ \\t]*(fast|normal|high|extra|best|highnew|extranew|bestnew)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
		{
			compressionLevelCheckBox->setChecked( true );
			compressionLevelComboBox->setEnabled( true );
			if ( regExp.cap( 2 ) == "fast" )
				compressionLevelComboBox->setCurrentItem( 0 );
			else if ( regExp.cap( 2 ) == "normal" )
				compressionLevelComboBox->setCurrentItem( 1 );
			else if ( regExp.cap( 2 ) == "high" )
				compressionLevelComboBox->setCurrentItem( 2 );
			else if ( regExp.cap( 2 ) == "extra" )
				compressionLevelComboBox->setCurrentItem( 3 );
			else if ( regExp.cap( 2 ) == "best" )
				compressionLevelComboBox->setCurrentItem( 4 );
			else if ( regExp.cap( 2 ) == "highnew" )
				compressionLevelComboBox->setCurrentItem( 5 );
			else if ( regExp.cap( 2 ) == "extranew" )
				compressionLevelComboBox->setCurrentItem( 6 );
			else // if ( regExp.cap( 2 ) == "bestnew" )
				compressionLevelComboBox->setCurrentItem( 7 );
		}

		// --optimize {none|fast*|normal|high|best}
		regExp.setPattern( "(^|[ \\t])--optimize[ \\t]*(none|fast|normal|high|best)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
		{
			optimizationCheckBox->setChecked( true );
			optimizationComboBox->setEnabled( true );
			if ( regExp.cap( 2 ) == "none" )
				optimizationComboBox->setCurrentItem( 0 );
			else if ( regExp.cap( 2 ) == "fast" )
				optimizationComboBox->setCurrentItem( 1 );
			else if ( regExp.cap( 2 ) == "norma" )
				optimizationComboBox->setCurrentItem( 2 );
			else if ( regExp.cap( 2 ) == "high" )
				optimizationComboBox->setCurrentItem( 3 );
			else if ( regExp.cap( 2 ) == "best" )
				optimizationComboBox->setCurrentItem( 4 );
		}

		// --seek {fast|normal*|slow|min}
		regExp.setPattern( "(^|[ \\t])--seek[ \\t]*(fast|normal|slow|min)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
		{
			seekingCheckBox->setChecked( true );
			seekingComboBox->setEnabled( true );
			if ( regExp.cap( 2 ) == "fast" )
				seekingComboBox->setCurrentItem( 0 );
			else if ( regExp.cap( 2 ) == "normal" )
				seekingComboBox->setCurrentItem( 1 );
			else if ( regExp.cap( 2 ) == "slow" )
				seekingComboBox->setCurrentItem( 2 );
			else if ( regExp.cap( 2 ) == "min" )
				seekingComboBox->setCurrentItem( 3 );
		}
	}

	regExp.setPattern( "(^|[ \\t])--recovery([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		recoveryInformationCheckBox->setChecked( true );

	regExp.setPattern( "(^|[ \\t])--md5([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		storeMD5CheckBox->setChecked( true );

	regExp.setPattern( "(^|[ \\t])--experimental([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		experimentalCompCheckBox->setChecked( true );
}

QString OFREncoderDialog::switches()
{
	QString result;

	if ( compressionLevelCheckBox->isChecked() )
	{
		if ( compressionLevelComboBox->currentItem() == 8 )
			result += "--maximumcompression";
		else
			switch ( compressionLevelComboBox->currentItem() )
			{
				case 0:		result += "--mode fast";		break;
				case 1:		result += "--mode normal";		break;
				case 2:		result += "--mode high";		break;
				case 3:		result += "--mode extra";		break;
				case 4:		result += "--mode best";		break;
				case 5:		result += "--mode highnew";		break;
				case 6:		result += "--mode extranew";	break;
				case 7:		result += "--mode bestnew";		break;
				default:									break;
			}
	}

	if ( optimizationCheckBox->isChecked() )
	{
		switch ( optimizationComboBox->currentItem() )
		{
			case 0:		result += " --optimize none";	break;
			case 1:		result += " --optimize fast";	break;
			case 2:		result += " --optimize normal";	break;
			case 3:		result += " --optimize high";	break;
			case 4:		result += " --optimize best";	break;
			default:									break;
		}
	}

	if ( seekingCheckBox->isChecked() )
	{
		switch ( seekingComboBox->currentItem() )
		{
			case 0:		result += " --seek fast";		break;
			case 1:		result += " --seek normal";		break;
			case 2:		result += " --seek slow";		break;
			case 3:		result += " --seek min";		break;
			default:									break;
		}
	}

	if ( recoveryInformationCheckBox->isChecked() )
		result += " --recovery";

	if ( storeMD5CheckBox->isChecked() )
		result += " --md5";

	if ( experimentalCompCheckBox->isChecked() )
		result += " --experimental";

	return result.simplifyWhiteSpace();
}
