/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "oggencencoderdialog.h"

#include <qregexp.h>
#include <qcheckbox.h>
#include <kcombobox.h>
#include <kdecspinbox.h>

OggEncEncoderDialog::OggEncEncoderDialog( QWidget* parent, const char* name ):
	OggEncEncoderDialogBase( parent, name ) {}

OggEncEncoderDialog::~OggEncEncoderDialog() {}

void OggEncEncoderDialog::setSwitches( const QString& switches )
{
	QRegExp regExp;

	regExp.setPattern( "(^|[ \\t])(-q|--quality)[ \\t]+(-?[0-9]+\\.?[0-9]*|-?[0-9]*\\.?[0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1  )
	{
		modeComboBox->setCurrentItem( 0 ); // Quality mode
		qualityCheckBox->setChecked( true );
		qualityDecSpinBox->setDecimalValue( regExp.cap( 3 ).toDouble() );
	}
	else
	{
		regExp.setPattern( "(^|[ \\t])(-b|--bitrate)[ \\t]+([0-9]+)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1  )
		{
			modeComboBox->setCurrentItem( 1 ); // Variable bitrate mode
			nominalBitrateCheckBox->setChecked( true );
			nominalBitrateSpinBox->setValue( regExp.cap( 3 ).toInt() );
		}

		regExp.setPattern( "(^|[ \\t])--managed([ \\t]|$)" );
		if ( regExp.search( switches ) != -1  )
			modeComboBox->setCurrentItem( 2 ); // Managed bitrate mode

		regExp.setPattern( "(^|[ \\t])(-m|--min-bitrate)[ \\t]+([0-9]+)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1  )
		{
			modeComboBox->setCurrentItem( 2 ); // Managed bitrate mode
			minimumBitrateCheckBox->setChecked( true );
			minimumBitrateSpinBox->setValue( regExp.cap( 3 ).toInt() );
		}

		regExp.setPattern( "(^|[ \\t])(-M|--max-bitrate)[ \\t]+([0-9]+)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1  )
		{
			modeComboBox->setCurrentItem( 2 ); // Managed bitrate mode
			maximumBitrateCheckBox->setChecked( true );
			maximumBitrateSpinBox->setValue( regExp.cap( 3 ).toInt() );
		}
	}
	changeItemMode();

	regExp.setPattern( "(^|[ \\t])--advanced-encode-option[ \\t]+lowpass_frequency=([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1  )
	{
		lowpassFilterCheckBox->setChecked( true );
		lowpassFilterDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
	}

	regExp.setPattern( "(^|[ \\t])--resample[ \\t]+([0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1  )
	{
		resampleCheckBox->setChecked( true );
		resampleSpinBox->setValue( regExp.cap( 2 ).toInt() );
	}

	regExp.setPattern( "(^|[ \\t])(--downmix)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1  )
		downmixCheckBox->setChecked( true );

	regExp.setPattern( "(^|[ \\t])--advanced-encode-option[ \\t]+bitrate_average_window=([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1  )
	{
		bitrateAvgWindowCheckBox->setChecked( true );
		bitrateAvgWindowDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
	}

	regExp.setPattern( "(^|[ \\t])--advanced-encode-option[ \\t]+impulse_noisetune=[ \\t]+(-?[0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1  )
	{
		impulseNoiseTuneCheckBox->setChecked( true );
		impulseNoiseTuneSpinBox->setValue( regExp.cap( 2 ).toInt() );
	}

	regExp.setPattern( "(^|[ \\t])--advanced-encode-option[ \\t]+impulse_trigger_profile=([0-4]\\.?[0-9]*|[0-4]?\\.?[0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1  )
	{
		impulseTriggerProfileCheckBox->setChecked( true );
		impulseTriggerProfileDecSpinBox->setDecimalValue( regExp.cap( 2 ).toDouble() );
	}
}

QString OggEncEncoderDialog::switches()
{
	QString result;

	if ( qualityCheckBox->isChecked() )
		result = "--quality " + qualityDecSpinBox->cleanText();
	else
	{
		if ( modeComboBox->currentItem() == 2 ) // Managed Mode
			result = "--managed";

		if ( nominalBitrateCheckBox->isChecked() )
			result += " --bitrate " + nominalBitrateSpinBox->cleanText();

		if ( minimumBitrateCheckBox->isChecked() )
			result += " --min-bitrate " + minimumBitrateSpinBox->cleanText();

		if ( maximumBitrateCheckBox->isChecked() )
			result += " --max-bitrate " + maximumBitrateSpinBox->cleanText();
	}

	if ( bitrateAvgWindowCheckBox->isChecked() )
		result += " --advanced-encode-option bitrate_average_window=" + bitrateAvgWindowDecSpinBox->cleanText();

	if ( impulseNoiseTuneCheckBox->isChecked() )
		result += " --advanced-encode-option impulse_noisetune=" + impulseNoiseTuneSpinBox->cleanText();

	if ( impulseTriggerProfileCheckBox->isChecked() )
		result += " --advanced-encode-option impulse_trigger_profile=" + impulseTriggerProfileDecSpinBox->cleanText();



	if ( lowpassFilterCheckBox->isChecked() )
		result += " --advanced-encode-option lowpass_frequency=" + lowpassFilterDecSpinBox->cleanText();

	if ( resampleCheckBox->isChecked() )
		result += " --resample " + resampleSpinBox->cleanText();

	if ( downmixCheckBox->isChecked() )
		result += " --downmix";

	return result.simplifyWhiteSpace();
}
