#ifndef TRANSKODE_PLUGIN_H
#define TRANSKODE_PLUGIN_H

/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include "processhandler.h"
#include "progressparser.h"
#include <commondefs.h>

#include <qmutex.h>
#include <kstandarddirs.h>

namespace TransKode
{
	class Plugin
	{
		public:

			friend class PluginsManager;

			Plugin( const QString& name=QString::null, const QString& desc=QString::null, const QString& program=QString::null, QStringList extensions=QStringList() ):
				m_name( name ),
				m_description( desc ),
				m_program( program ),
				m_programPath( m_program ),
				m_extensions( extensions ),
				m_mutex( true ) {}
			~Plugin() {}

			const QString& name() const
			{
				return m_name;
			}

			const QString& description() const
			{
				return m_description;
			}

			const QString& program() const
			{
				return m_program;
			}

			QString programPath() const
			{
				m_mutex.lock();

				QString ret = String::deepCopy( m_programPath );

				m_mutex.unlock();

				return ret;
			}

			bool isLocallySupported() const
			{
				return KStandardDirs::findExe( programPath() ) != QString::null;
			}

			const QStringList& extensions() const
			{
				return m_extensions;
			}

			virtual ProgressParser* newProgressParser() const = 0;

			bool knowsExtensionMetadata( const QString& extension ) const
			{
				QString ext = extension.lower();
				for ( QStringList::ConstIterator it = m_extensions.begin(); it != m_extensions.end(); ++it )
				{
					if ( *it == ext && *it != "*" )
						return true;
				}
				return false;
			}

		protected:

			virtual void setProgramPath( const QString& path )
			{
				m_mutex.lock();

				m_programPath = path;

				m_mutex.unlock();
			}

			QString m_name;
			QString m_description;

			QString m_program;
			QString m_programPath;

			QStringList m_extensions;

			mutable QMutex m_mutex;
	};
}

#endif
