/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "pluginsmanager.h"

#include <bonkdecoderplugin.h>
#include <cpdecoderplugin.h>
#include <faaddecoderplugin.h>
#include <ffmpegdecoderplugin.h>
#include <flacdecoderplugin.h>
#include <gstlaunchdecoderplugin.h>
#include <ladecoderplugin.h>
#include <lamedecoderplugin.h>
#include <lpacdecoderplugin.h>
#include <macdecoderplugin.h>
#include <mplayerdecoderplugin.h>
#include <mppdecdecoderplugin.h>
#include <ofrdecoderplugin.h>
#include <oggdecdecoderplugin.h>
#include <speexdecdecoderplugin.h>
#include <ttaencdecoderplugin.h>
#include <wadumpdecoderplugin.h>
#include <wvunpackdecoderplugin.h>
#include <shortendecoderplugin.h>
#include <xineadumpdecoderplugin.h>

#include <bonkencoderplugin.h>
#include <cpencoderplugin.h>
#include <faacencoderplugin.h>
#include <ffmpegencoderplugin.h>
#include <flacencoderplugin.h>
#include <gstlaunchencoderplugin.h>
#include <laencoderplugin.h>
#include <lameencoderplugin.h>
#include <lpacencoderplugin.h>
#include <macencoderplugin.h>
#include <mppencencoderplugin.h>
#include <ofrencoderplugin.h>
#include <oggencencoderplugin.h>
#include <speexencencoderplugin.h>
#include <ttaencencoderplugin.h>
#include <twolameencoderplugin.h>
#include <wavpackencoderplugin.h>
#include <shortenencoderplugin.h>

using namespace TransKode;

QPtrList<DecoderPlugin> PluginsManager::s_decoderPlugins;
QPtrList<EncoderPlugin> PluginsManager::s_encoderPlugins;
bool PluginsManager::s_loaded( false );

void PluginsManager::loadPlugins()
{
	if ( s_loaded )
		return;

	s_decoderPlugins.append( new BonkDecoderPlugin() );
	s_decoderPlugins.append( new FAADDecoderPlugin() );
	s_decoderPlugins.append( new FLACDecoderPlugin() );
	s_decoderPlugins.append( new LADecoderPlugin() );
	s_decoderPlugins.append( new LAMEDecoderPlugin() );
	s_decoderPlugins.append( new LPACDecoderPlugin() );
	s_decoderPlugins.append( new MACDecoderPlugin() );
	s_decoderPlugins.append( new MPPDecDecoderPlugin() );
	s_decoderPlugins.append( new OFRDecoderPlugin() );
	s_decoderPlugins.append( new OggDecDecoderPlugin() );
	s_decoderPlugins.append( new SpeexDecDecoderPlugin() );
	s_decoderPlugins.append( new TTAEncDecoderPlugin() );
	s_decoderPlugins.append( new WvUnpackDecoderPlugin() );
	s_decoderPlugins.append( new ShortenDecoderPlugin() );
	s_decoderPlugins.append( new FFmpegDecoderPlugin() );
	s_decoderPlugins.append( new GstLaunchDecoderPlugin() );
	s_decoderPlugins.append( new MPlayerDecoderPlugin() );
	s_decoderPlugins.append( new CPDecoderPlugin() );
	s_decoderPlugins.append( new XineadumpDecoderPlugin() );
	s_decoderPlugins.append( new WadumpDecoderPlugin() );
	s_decoderPlugins.setAutoDelete( true );

	s_encoderPlugins.append( new BonkEncoderPlugin() );
	s_encoderPlugins.append( new FAACEncoderPlugin() );
	s_encoderPlugins.append( new FLACEncoderPlugin() );
	s_encoderPlugins.append( new FFmpegEncoderPlugin() );
	s_encoderPlugins.append( new GstLaunchEncoderPlugin() );
	s_encoderPlugins.append( new LAEncoderPlugin() );
	s_encoderPlugins.append( new LAMEEncoderPlugin() );
	s_encoderPlugins.append( new LPACEncoderPlugin() );
	s_encoderPlugins.append( new MACEncoderPlugin() );
	s_encoderPlugins.append( new MPPEncEncoderPlugin() );
	s_encoderPlugins.append( new OFREncoderPlugin() );
	s_encoderPlugins.append( new OggEncEncoderPlugin() );
	s_encoderPlugins.append( new SpeexEncEncoderPlugin() );
	s_encoderPlugins.append( new TTAEncEncoderPlugin() );
	s_encoderPlugins.append( new TwoLAMEEncoderPlugin() );
	s_encoderPlugins.append( new WavPackEncoderPlugin() );
	s_encoderPlugins.append( new ShortenEncoderPlugin() );
	s_encoderPlugins.append( new CPEncoderPlugin() );
	s_encoderPlugins.setAutoDelete( true );

	s_loaded = true;
}

void PluginsManager::unloadPlugins()
{
	if ( ! s_loaded )
		return;

	s_decoderPlugins.clear();
	s_encoderPlugins.clear();

	s_loaded = false;
}

QStringList PluginsManager::encoderPluginNames()
{
	loadPlugins();

	QStringList ret;

	for ( QPtrListIterator<EncoderPlugin> it( s_encoderPlugins ); it.current() != 0; ++it )
		ret.append( (*it)->name() );

	return ret;
}


QStringList PluginsManager::decoderPluginNames()
{
	loadPlugins();

	QStringList ret;

	for ( QPtrListIterator<DecoderPlugin> it( s_decoderPlugins ); it.current() != 0; ++it )
		ret.append( (*it)->name() );

	return ret;
}


const DecoderPlugin* PluginsManager::decoderPlugin( const QString& name )
{
	loadPlugins();

	for ( QPtrListIterator<DecoderPlugin> it( s_decoderPlugins ); it.current() != 0; ++it )
		if ( (*it)->name() == name )
			return *it;
	return 0;
}


const EncoderPlugin* PluginsManager::encoderPlugin( const QString& name )
{
	loadPlugins();

	for ( QPtrListIterator<EncoderPlugin> it( s_encoderPlugins ); it.current() != 0; ++it )
		if ( (*it)->name() == name )
			return *it;
	return 0;
}


QStringList PluginsManager::programs()
{
	loadPlugins();

	QStringList ret;

	for ( QPtrListIterator<DecoderPlugin> it( s_decoderPlugins ); it.current() != 0; ++it )
		if ( ! ret.contains( (*it)->program() ) )
			ret.append( (*it)->program() );

	for ( QPtrListIterator<EncoderPlugin> it( s_encoderPlugins ); it.current() != 0; ++it )
		if ( ! ret.contains( (*it)->program() ) )
			ret.append( (*it)->program() );

	return ret;
}

QString PluginsManager::programPath( const QString program )
{
	loadPlugins();

	for ( QPtrListIterator<DecoderPlugin> it( s_decoderPlugins ); it.current() != 0; ++it )
		if ( (*it)->program() == program )
			return (*it)->programPath();

	for ( QPtrListIterator<EncoderPlugin> it( s_encoderPlugins ); it.current() != 0; ++it )
		if ( (*it)->program() == program )
			return (*it)->programPath();

	return QString::null;
}

void PluginsManager::setProgramPath( const QString program, const QString path )
{
	loadPlugins();

	for ( QPtrListIterator<DecoderPlugin> it( s_decoderPlugins ); it.current() != 0; ++it )
		if ( (*it)->program() == program )
			(*it)->setProgramPath( path );

	for ( QPtrListIterator<EncoderPlugin> it( s_encoderPlugins ); it.current() != 0; ++it )
		if ( (*it)->program() == program )
			(*it)->setProgramPath( path );
}
