#ifndef TRANSKODE_PLUGINSMANAGER_H
#define TRANSKODE_PLUGINSMANAGER_H

/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include "decoderplugin.h"
#include "encoderplugin.h"
#include <logger.h>

#include <qptrlist.h>

namespace TransKode
{
	class PluginsManager
	{
		public:

			//static void load( const QString definitionFile );
			static void loadPlugins();
			static void unloadPlugins();

			static QStringList decoderPluginNames();
			static QStringList encoderPluginNames();

			static const DecoderPlugin* decoderPlugin( const QString& name );
			static const EncoderPlugin* encoderPlugin( const QString& name );

			static QStringList programs();

			static QString programPath( const QString program );
			static void setProgramPath( const QString program, const QString path );

		protected:

			static QPtrList<DecoderPlugin> s_decoderPlugins;
			static QPtrList<EncoderPlugin> s_encoderPlugins;
			static bool s_loaded;
	};
}

#endif
