#ifndef TRANSKODE_PROCESSHANDLER_H
#define TRANSKODE_PROCESSHANDLER_H

/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <qstring.h>
#include <qstringlist.h>
#include <qprocess.h>
#include <qwaitcondition.h>
#include <qmutex.h>

class ProcessHandler : public QProcess
{
	Q_OBJECT

	public:
		ProcessHandler( int priority = 0, int comm = 0, QObject* parent = 0, const char* name = 0 );
		ProcessHandler( const QString& arg0, int priority = 0, int comm = 0, QObject* parent = 0, const char* name = 0 );
		ProcessHandler( const QStringList& args, int priority = 0, int comm = 0, QObject* parent = 0, const char* name = 0 );
		virtual ~ProcessHandler();

		virtual bool start( QStringList* env = 0 );

		void terminate( unsigned long msecs );

		bool waitProcess( unsigned long msecs=ULONG_MAX );

		void setShellParsingMode( bool value );
		bool getShellParsingMode();

		virtual void setArguments( const QStringList& args );
		virtual void addArgument( const QString& arg );
		virtual void addArguments( const QStringList& args );

		ProcessHandler& operator<<( long arg );
// 		ProcessHandler& operator<<( unsigned long arg );

		ProcessHandler& operator<<( const QString& arg );
		ProcessHandler& operator<<( const char* arg );
		ProcessHandler& operator<<( const QByteArray& arg );
		ProcessHandler& operator<<( const QStringList& args );

		static QStringList parseShellArgs( const QString& args );

		int priority() const;
		bool setPriority( int value );

		bool paused() const;
		bool pause();
		bool resume();

	protected slots:
		void onProcessExited();

	protected:

		bool setPriority( int value, bool force );

		int m_priority;
		bool m_paused;
		bool m_shellParsing;
		QWaitCondition m_waitCondition;
		QMutex m_mutex;
		bool m_finished;
};

#endif

