#ifndef TRANSKODE_PROCESSOUTPUT_H
#define TRANSKODE_PROCESSOUTPUT_H

/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <qobject.h>
#include <qprocess.h>
#include <qthread.h>
#include <qmutex.h>
#include <qwaitcondition.h>

/**
 * You must _always_ destroy the OutputParser (ProgressParser) object
 * before destroying the qprocess received in the contructor
 */

class OutputParser : public QObject
{
	Q_OBJECT

	public:
		OutputParser( QObject* parent = 0, const char* name = 0 );
		virtual ~OutputParser();

		virtual void parseOutput( const QString& output ) = 0;
};

class OutputGrabber : public QObject
{
	Q_OBJECT

	public:
		OutputGrabber( QProcess* process );
		virtual ~OutputGrabber();

		QByteArray getOutput();
		QByteArray takeOutput();

		QString getOutputAsString();
		QString takeOutputAsString();

	protected slots:
		void saveStdout();
		void saveStderr();

	protected:
		QProcess* m_process;
		QByteArray m_output;
		QMutex m_mutex;
};

/**
 * You must _always_ destroy the ProcessOutputParserProxy instance
 * before destroying the qprocess received in the contructor
 */

class OutputParserProxy : public QThread
{
	public:
		OutputParserProxy( QProcess* process, OutputParser* parser, unsigned pollInterval=250 );
		virtual ~OutputParserProxy();

	protected:
		virtual void run();
		bool stop();

	protected:
		OutputParser* m_parser;
		unsigned m_pollInterval;

		OutputGrabber m_outputGrabber;

		bool m_stop;
		QMutex m_mutex;
};

#endif
