/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include "shortenencoderdialog.h"

#include <qregexp.h>
#include <qcheckbox.h>
#include <kcombobox.h>
#include <kdecspinbox.h>

ShortenEncoderDialog::ShortenEncoderDialog( QWidget* parent, const char* name ):
	ShortenEncoderDialogBase( parent, name ) {}

ShortenEncoderDialog::~ShortenEncoderDialog() {}

void ShortenEncoderDialog::setSwitches( const QString& switches )
{
	QRegExp regExp;

	regExp.setPattern( "(^|[ \\t])-b[ \\t]*([0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		blockSizeCheckBox->setChecked( true );
		int blockSize = regExp.cap( 2 ).toInt();
		blockSizeSpinBox->setValue( blockSize < 4 ? 4 : blockSize );
	}

	regExp.setPattern( "(^|[ \\t])-m[ \\t]*([0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		meanEstimationCheckBox->setChecked( true );
		int blocks = regExp.cap( 2 ).toInt();
		meanEstimationSpinBox->setValue( blocks );
	}

	regExp.setPattern( "(^|[ \\t])-n[ \\t]*([0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		minSTNRatioCheckBox->setChecked( true );
		int ratio = regExp.cap( 2 ).toInt();
		minSTNRatioSpinBox->setValue( ratio > 256 ? 256 : ratio );
	}

	regExp.setPattern( "(^|[ \\t])-p[ \\t]*([0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		maxLPFOrderCheckBox->setChecked( true );
		int order = regExp.cap( 2 ).toInt();
		maxLPFOrderSpinBox->setValue( order > 64 ? 64 : order );
	}

	regExp.setPattern( "(^|[ \\t])-q[ \\t]*([0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		quantizationLevelCheckBox->setChecked( true );
		int bits = regExp.cap( 2 ).toInt();
		quantizationLevelSpinBox->setValue( bits > 32 ? 32 : bits );
	}


	regExp.setPattern( "(^|[ \\t])-r[ \\t]*([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		maxBitsPerSampleCheckBox->setChecked( true );
		float bitsPerSample = regExp.cap( 2 ).toFloat();
		maxBitsPerSampleDecSpinBox->setDecimalValue( bitsPerSample > 32.0 ? 32.0 : bitsPerSample );
	}

	regExp.setPattern( "(^|[ \\t])-a[ \\t]*([0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		bytesToCopyCheckBox->setChecked( true );
		int bytes = regExp.cap( 2 ).toInt();
		bytesToCopySpinBox->setValue( bytes );
	}

	regExp.setPattern( "(^|[ \\t])-d[ \\t]*([0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		bytesToDiscardCheckBox->setChecked( true );
		int bytes = regExp.cap( 2 ).toInt();
		bytesToDiscardSpinBox->setValue( bytes );
	}

	regExp.setPattern( "(^|[ \\t])-v[ \\t]*([012])([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		versionCheckBox->setChecked( true );
		int version = regExp.cap( 2 ).toInt();
		versionComboBox->setCurrentItem( version );
	}
}

QString ShortenEncoderDialog::switches()
{
	QString result;

	if ( blockSizeCheckBox->isChecked() )
		result += " -b " + blockSizeSpinBox->cleanText();
	if ( meanEstimationCheckBox->isChecked() )
		result += " -m " + meanEstimationSpinBox->cleanText();
	if ( minSTNRatioCheckBox->isChecked() )
		result += " -n " + minSTNRatioSpinBox->cleanText();
	if ( maxLPFOrderCheckBox->isChecked() )
		result += " -p " + maxLPFOrderSpinBox->cleanText();
	if ( quantizationLevelCheckBox->isChecked() )
		result += " -q " + quantizationLevelSpinBox->cleanText();
	if ( maxBitsPerSampleCheckBox->isChecked() )
		result += " -r " + maxBitsPerSampleDecSpinBox->cleanText();
	if ( bytesToCopyCheckBox->isChecked() )
		result += " -a " + bytesToCopySpinBox->cleanText();
	if ( bytesToDiscardCheckBox->isChecked() )
		result += " -d " + bytesToDiscardSpinBox->cleanText();
	if ( versionCheckBox->isChecked() )
		result += " -v " + QString::number( versionComboBox->currentItem() );

	return result.simplifyWhiteSpace();
}
