/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include "speexencencoderdialog.h"

#include <qregexp.h>
#include <qslider.h>
#include <qcheckbox.h>
#include <knuminput.h>

SpeexEncEncoderDialog::SpeexEncEncoderDialog( QWidget* parent, const char* name ):
	SpeexEncEncoderDialogBase( parent, name ) {}

SpeexEncEncoderDialog::~SpeexEncEncoderDialog() {}

void SpeexEncEncoderDialog::setSwitches( const QString& switches )
{
	QRegExp regExp;

	regExp.setPattern( "(^|[ \\t])--quality[ \\t]+([0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		qualityCheckBox->setChecked( true );
		qualitySpinBox->setEnabled( true );
		int quality = regExp.cap( 2 ).toInt();
		qualitySpinBox->setValue( quality>10 ? 8 : quality );
	}

	regExp.setPattern( "(^|[ \\t])--comp[ \\t]+([0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		complexityCheckBox->setChecked( true );
		complexitySpinBox->setEnabled( true );
		int complexity = regExp.cap( 2 ).toInt();
		complexitySpinBox->setValue( complexity > 10 ? 3 : complexity );
	}

	regExp.setPattern( "(^|[ \\t])(--vbr)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		vbrCheckBox->setChecked( true );

	regExp.setPattern( "(^|[ \\t])(--vad)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		vadCheckBox->setChecked( true );

	regExp.setPattern( "(^|[ \\t])(--dtx)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		dtxCheckBox->setChecked( true );

	regExp.setPattern( "(^|[ \\t])(--denoise)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		denoiseCheckBox->setChecked( true );

	regExp.setPattern( "(^|[ \\t])(--agc)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		gainControlCheckBox->setChecked( true );

	regExp.setPattern( "(^|[ \\t])--nframes[ \\t]+([1-9]|10)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		framesPerPacketCheckBox->setChecked( true );
		framesPerPacketSpinBox->setValue( regExp.cap( 2 ).toInt() );
	}
}

QString SpeexEncEncoderDialog::switches()
{
	QString result;

	if ( qualityCheckBox->isChecked() )
		result += "--quality " + QString::number( qualitySpinBox->value() );
	if ( complexityCheckBox->isChecked() )
		result += " --comp " + QString::number( complexitySpinBox->value() );
	if ( framesPerPacketCheckBox->isChecked() )
		result += " --nframes " + QString::number( framesPerPacketSpinBox->value() );
	if ( vbrCheckBox->isChecked() )
		result += " --vbr";
	if ( vadCheckBox->isChecked() )
		result += " --vad";
	if ( dtxCheckBox->isChecked() )
		result += " --dtx";
	if ( denoiseCheckBox->isChecked() )
		result += " --denoise";
	if ( gainControlCheckBox->isChecked() )
		result += " --agc";

	return result.simplifyWhiteSpace();
}
