#ifndef TRANSKODE_TWOLAMEENCODERPLUGIN_H
#define TRANSKODE_TWOLAMEENCODERPLUGIN_H

/***************************************************************************
 *   Copyright (C) 2007 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <encoderplugin.h>
#include "twolameencoderdialog.h"

#include <audioproperties.h>
#include <mpegfile.h>

namespace TransKode
{
	class TwoLAMEEncoderPlugin : public EncoderPlugin
	{
		friend class PluginsManager;

		public:

			virtual bool configurable() const
			{
				return true;
			}

			virtual void setupArgs( ProcessHandler& proc, const QString& src, const QString& dst, const QString& switches, const Metadata& ) const
			{
				proc.clearArguments();
				bool pMode = proc.getShellParsingMode();
				proc.setShellParsingMode( false );
				proc << programPath();
				proc.setShellParsingMode( true );
				proc << switches;
				proc.setShellParsingMode( false );
				proc << src << dst;
				proc.setShellParsingMode( pMode );
			}

			virtual ProgressParser* newProgressParser() const
			{
				return new RegExpProgressParser( ".*\\((\\d+)%\\)", RegExpProgressParser::int_percentage );
			}

			virtual TagLib::File* newTagLibFile( const char* fileName, bool readAudioProp, int audioPropStyle ) const
			{
				return new TagLib::MPEG::File( fileName, readAudioProp, (TagLib::AudioProperties::ReadStyle)audioPropStyle );
			}

		protected:

			virtual EncoderDialog* _newEncoderDialog( QWidget* parent=0, const char* name=0 ) const
			{
				return new TwoLAMEEncoderDialog( parent, name );
			}

			TwoLAMEEncoderPlugin():EncoderPlugin( "TwoLAME", QString::null, "twolame", QStringList::split( ":", "mp2:*" ) ) {}

			~TwoLAMEEncoderPlugin() {}
	};
}

#endif

