/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "wavpackencoderdialog.h"

#include <qregexp.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <kcombobox.h>
#include <kdecspinbox.h>

WavPackEncoderDialog::WavPackEncoderDialog( QWidget* parent, const char* name ):
	WavPackEncoderDialogBase( parent, name ) {}

WavPackEncoderDialog::~WavPackEncoderDialog() {}

void WavPackEncoderDialog::setSwitches( const QString& switches )
{
	QRegExp regExp;

	regExp.setPattern( "(^|[ \\t])-(f|h)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		encodingModeCheckBox->setChecked( true );
		if ( regExp.cap( 2 ) == "h" )
			encodingModeComboBox->setCurrentItem( 0 );
		else if ( regExp.cap( 2 ) == "f" )
			encodingModeComboBox->setCurrentItem( 2 );
	}
	else
		encodingModeComboBox->setCurrentItem( 1 );

	regExp.setPattern( "(^|[ \\t])-j(0|1)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		jointStereoCheckBox->setChecked( true );
		if ( regExp.cap( 2 ) == "0" )
			jointStereoComboBox->setCurrentItem( 1 );
		else if ( regExp.cap( 2 ) == "1" )
			jointStereoComboBox->setCurrentItem( 0 );
	}

	regExp.setPattern( "(^|[ \\t])-x(|[1-6])([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		extraProcessingCheckBox->setChecked( true );
		if ( ! regExp.cap( 2 ).isEmpty() )
		{
			extraProcessingLevelCheckBox->setChecked( true );
			extraProcessingLevelSpinBox->setValue( regExp.cap( 2 ).toInt() );
		}
	}


	regExp.setPattern( "(^|[ \\t])-b([0-2]?[0-9].[0-9]|[0-9][0-9]+)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
	{
		double val = regExp.cap( 2 ).toDouble();

		hybridButtonGroup->setChecked( true );
		if ( val < 24 )
		{
			bitsPerSampleRadioButton->setChecked( true );
			bitsPerSampleDecSpinBox->setDecimalValue( val );
		}
		else
		{
			kbitsPerSecondRadioButton->setChecked( true );
			kbitsPerSecondSpinBox->setValue( (int)val );
		}

		regExp.setPattern( "(^|[ \\t])(-c)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
			correctionFileCheckBox->setChecked( true );

		regExp.setPattern( "(^|[ \\t])(-cc)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
			maxHybridCompCheckBox->setChecked( true );

		regExp.setPattern( "(^|[ \\t])-s(|-)(0?\\.[0-9]|1\\.0|1|0)([ \\t]|$)" );
		if ( regExp.search( switches ) != -1 )
		{
			noiseShapingCheckBox->setChecked( true );
			noiseShapingDecSpinBox->setDecimalValue( regExp.cap( 3 ).toDouble() * (regExp.cap( 2 ).isEmpty() ? 1 : -1) );
		}
	}

	regExp.setPattern( "(^|[ \\t])(-r)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		riffHeaderCheckBox->setChecked( true );

	regExp.setPattern( "(^|[ \\t])(-i)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		ignoreHeaderCheckBox->setChecked( true );

	regExp.setPattern( "(^|[ \\t])(-p)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		practicalFloatCheckBox->setChecked( true );

	regExp.setPattern( "(^|[ \\t])(-a)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		auditionCheckBox->setChecked( true );

	regExp.setPattern( "(^|[ \\t])(-m)([ \\t]|$)" );
	if ( regExp.search( switches ) != -1 )
		md5sumCheckBox->setChecked( true );
}

QString WavPackEncoderDialog::switches()
{
	QString result;

	if ( encodingModeCheckBox->isChecked() )
	{
		if ( encodingModeComboBox->currentItem() == 0 )
			result += "-h";
		else if ( encodingModeComboBox->currentItem() == 2 )
			result += "-f";
	}

	if ( jointStereoCheckBox->isChecked() )
	{
		if ( jointStereoComboBox->currentItem() == 0 )
			result += " -j1";
		else // if ( jointStereoComboBox->currentItem() == 1 )
			result += " -j0";
	}

	if ( extraProcessingCheckBox->isChecked() )
	{
		result += " -x";
		if ( extraProcessingLevelCheckBox->isChecked() )
			result += QString::number( extraProcessingLevelSpinBox->value() );
	}

	if ( hybridButtonGroup->isChecked() )
	{
		if ( bitsPerSampleRadioButton->isChecked() )
			result += " -b" + QString::number( bitsPerSampleDecSpinBox->decimalValue(), 'f', 1 );
		else // if ( kbitsPerSecondRadioButton->isChecked() )
			result += " -b" + QString::number( kbitsPerSecondSpinBox->value() );

		if ( correctionFileCheckBox->isChecked() )
			result += " -c";

		if ( maxHybridCompCheckBox->isChecked() )
			result += " -cc";

		if ( noiseShapingCheckBox->isChecked() )
			result += " -s" + QString::number( noiseShapingDecSpinBox->decimalValue(), 'f', 1 );
	}

	if ( riffHeaderCheckBox->isChecked() )
		result += " -r";

	if ( ignoreHeaderCheckBox->isChecked() )
		result += " -i";

	if ( practicalFloatCheckBox->isChecked() )
		result += " -p";

	if ( auditionCheckBox->isChecked() )
		result += " -a";

	if ( md5sumCheckBox->isChecked() )
		result += " -m";

	return result;
}
