#ifndef TRANSKODE_LISTVIEW_H
#define TRANSKODE_LISTVIEW_H

/***************************************************************************
*   Copyright (C) 2006 by Sergio Pistone                                  *
*   sergio_pistone@yahoo.com.ar                                           *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <appconfig.h>
#include <jobqueue.h>

#include <klistview.h>
#include <qsimplerichtext.h>

namespace TransKode
{
	class ListViewItem;

	class ListView : public KListView
	{
		Q_OBJECT

		friend class ListViewItem;

		public:

			enum Columns {
				src_path = 0, src_dir = 1, src_file = 2,
				dst_path = 3, dst_dir = 4, dst_file = 5,
				profile = 6, status = 7, SIZE
			};

			ListView( QWidget *parent, const AppConfig& config, JobQueue& queue );

			ListViewItem* add( const QString& file, ListViewItem* after = 0 );
			ListViewItem* add( const QStringList& files, ListViewItem* after = 0 );

			bool removeSelected();
			bool removeAll();
			void removeFinished();

			void enqueueSelected();
			bool dequeueSelected();

			void selectAll();
			void refreshSelected();

			// control related functions:
			void saveConfig();
			void loadConfig();

			virtual bool eventFilter( QObject* object, QEvent* event );

			void setItemHorizontalMargin( uint margin );
			uint itemHorizontalMargin();

		signals:

			void jobFinishedOK( long jobID );
			void jobFinishedWithError( long jobID );
			void jobCancelled( long jobID );

		protected:
			bool acceptDrag( QDropEvent* event ) const;
			QDragObject* dragObject();

			virtual void contextMenuEvent( QContextMenuEvent* e );

			virtual void viewportPaintEvent( QPaintEvent* e );
			virtual void viewportResizeEvent( QResizeEvent* );

		protected slots:

			void onDropEvent( QDropEvent* event, QListViewItem* after );

			void slotSetSortColumn( int column );
			void slotAdjustColumnWidth( int column );

		protected:
			const AppConfig& m_config;
			JobQueue& m_queue;

			QValueList<int> m_sortColumns;
			uint m_horizMargin;

			QSimpleRichText* m_startMsgRichText;
	};
}

#endif
