#ifndef TRANSKODE_LISTVIEWITEM_H
#define TRANSKODE_LISTVIEWITEM_H

/***************************************************************************
*   Copyright (C) 2006 by Sergio Pistone                                  *
*   sergio_pistone@yahoo.com.ar                                           *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <filejob.h>
#include <jobqueue.h>

#include <qobject.h>
#include <qprogressbar.h>

#include <klistview.h>
#include <klocale.h>

// random number for ListViewItem RTTI
#define TRANSKODE 1353

namespace TransKode
{
	class ListView;

	class ListViewItem : public QObject, public KListViewItem
	{
		Q_OBJECT

		public:
			ListViewItem( QListView* parent, const AppConfig& config, const QString& srcPath );
			virtual ~ListViewItem();

			FileJob* job() const;

			void enqueue( JobQueue* queue );

			void setProfile( const QString& profile );
			void resetProfile();

			void stop();
			void remove();

			bool isQueueable() const;
			bool isEnqueued() const;
			bool isCancellable() const;
			bool isRefresheable() const;
			bool isRunning() const;
			bool isFinishedOK() const;
			bool isFinishedWithError() const;

		protected:

			// reimplemented to provide runtime type information
			inline int rtti() const { return TRANSKODE; }

			// reimplemented to sort based on more than one column
			virtual int compare( QListViewItem* item, int column, bool ascending ) const;
			virtual int compareAux( QListViewItem* item, int column, bool ascending ) const;

			// reimplemented to draw progress bar
			virtual void paintCell( QPainter *p, const QColorGroup &cg, int column, int width, int align );

		protected slots: // slots to update the item from the job signals

			void setDstPath( long jobID, const QString& path );

			void setStarted();
			void setProgress( long jobID, int progress );

			void setFinishedOK();
			void setFinishedWithError( long jobID, const QString& errorMsg );
			void setCancelled();

		protected:

			FileJob* m_job;
			JobQueue* m_queue;

			bool m_delayedDeletion;
	};
}

#endif
