#ifndef TRANSKODE_MAINWINDOW_H
#define TRANSKODE_MAINWINDOW_H

/***************************************************************************
 *   Copyright (C) 2006 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include "listview.h"
#include <metadatawidget.h>
#include <logger.h>
#include <appconfig.h>
#include <configdialog.h>
#include <jobqueue.h>
#include <worker.h>

#include <kmainwindow.h>
#include <ksystemtray.h>
#include <kaction.h>

#include <qptrlist.h>

namespace TransKode
{
	class MainWindow : public KMainWindow
	{
		Q_OBJECT

		public:
			MainWindow();
			virtual ~MainWindow();

			static void filesInDir( const QString& dir, QStringList& files );
			static QMap<QString,QStringList> supportedFormatsMap();
			static QStringList buildSupportedFormatsExtensions();
			static QString buildSupportedFormatsFilter();

		protected:
			void saveConfig();
			void loadConfig();

			virtual bool queryClose();

			void setupActions();

		protected slots:

			void updateProcessingState();
			void updateActionsState();
			void updateStatusBar();

			void loadSelectedItemsMetadata();
			void saveSelectedItemsMetadata();

			void showPreferences();
			void showConfirmQuit();
			void updateConfigFromDialog();
			void toggleToolBarFilterEnabled( bool enabled );

			void togglePaused();

			void add();
			void removeSelected();
			void removeFinished();
			void removeAll();

			void enqueueSelected();
			void dequeueSelected();

			void selectAll();
			void refreshSelected();

		protected:

			Logger& m_logger;
			AppConfig m_config;
			JobQueue m_queue;

			ConfigDialog m_configDialog;
			ListView* m_listView;
			MetadataWidget* m_metadataWidget;
			KSystemTray* m_systemTray;

			KAction* m_enqueueFilesAction;
			KAction* m_dequeueFilesAction;
			KAction* m_refreshFilesAction;
			KAction* m_selectAllAction;
			KAction* m_invertSelectionAction;
			KAction* m_clearAllAction;
			KAction* m_clearFinishedAction;
			KToggleAction* m_pauseEncodingAction;
			KWidgetAction* m_searchAction;
			KToggleToolBarAction* m_searchManagerAction;

			QString m_lastDir;
	};
}

#endif
