#ifndef TRANSKODE_METADATAWIDGET_H
#define TRANSKODE_METADATAWIDGET_H

/***************************************************************************
*   Copyright (C) 2006 by Sergio Pistone                                  *
*   sergio_pistone@yahoo.com.ar                                           *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <commondefs.h>
#include <metadata.h>

#include <metadatawidgetbase.h>

#include <qobject.h>
#include <qwidget.h>
#include <qvaluelist.h>

namespace TransKode
{
	typedef QValueList<Metadata> MetadataList;

	class MetadataWidget : public MetadataWidgetBase
	{
		Q_OBJECT

		public:
			MetadataWidget( QWidget* parent = 0, const char* name = 0 );
			virtual ~MetadataWidget();

			void setGenresList( const QStringList& genres );

			Metadata metadata();
			void setEmptyMetadata();
			void setMetadata( const Metadata& metadata );
			void setMetadata( const MetadataList& metadatas );

		signals:
			void metadataSetted();

		protected:

			void setCheckBoxsVisible( bool visible );
			void setCheckBoxsChecked( bool checked );
			void setCheckBoxChecked( Metadata::Tag tag, bool checked );
			void setButtonsEnabled( bool enabled );

		protected slots:

			void set();
			void reset();

			void setCommentTextEditEditable( bool editable );

			void setButtonsEnabled();
			void setButtonsDisabled();

		protected:

			Metadata m_metadata;
	};
}

#endif
