/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pistone                                  *
 *   sergio_pistone@yahoo.com.ar                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "kdecspinbox.h"
#include <limits.h>
#include <math.h>

KDecSpinBox::KDecSpinBox( QWidget* parent, const char* name ):
	KIntSpinBox( parent, name ),
	m_validator( new KDecValidator( this ) )
{
	setValidator( m_validator );
	setPrecision( 2 );
}

double KDecSpinBox::positivePower( int value, unsigned power )
{
	double result = 1;
	for ( unsigned count = 0; count < power; ++count )
		result *= value;
	return result;
}

int KDecSpinBox::precision() const
{
	return m_precision;
}

void KDecSpinBox::setPrecision( int precision )
{
	if ( precision >= 0 && precision < 10 )
	{
		m_precision = precision;
		m_precisionConstant = positivePower( 10, m_precision );
		m_validator->setMinimum( minValue()/m_precisionConstant );
		m_validator->setMaximum( maxValue()/m_precisionConstant );
		setValue( value() ); // Update control representation
	}
}

int KDecSpinBox::minValue() const
{
	return KIntSpinBox::minValue();
}

void KDecSpinBox::setMinValue( int minValue )
{
	KIntSpinBox::setMinValue( minValue );
	m_validator->setMinimum( minValue/m_precisionConstant );
}

int KDecSpinBox::maxValue() const
{
	return KIntSpinBox::maxValue();
}

void KDecSpinBox::setMaxValue( int maxValue )
{
	KIntSpinBox::setMaxValue( maxValue );
	m_validator->setMaximum( maxValue/m_precisionConstant );
}

double KDecSpinBox::decimalValue()
{
	return KIntSpinBox::value()/m_precisionConstant;
}

void KDecSpinBox::setDecimalValue( double value )
{
	double aux = floor( value*m_precisionConstant );
	if ( aux >= INT_MAX )
		KIntSpinBox::setValue( INT_MAX );
	else if ( aux <= INT_MIN )
		KIntSpinBox::setValue( INT_MIN );
	else
		KIntSpinBox::setValue( (int)aux );
}

QString KDecSpinBox::mapValueToText( int value )
{
	return QString::number( value/m_precisionConstant, 'f', m_precision );
}

int KDecSpinBox::mapTextToValue( bool* ok )
{
	return (int)floor( cleanText().toDouble( ok )*m_precisionConstant );
}
